<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoDescriptionType StructType
 * @subpackage Structs
 */
class VideoDescriptionType extends AbstractStructBase
{
    /**
     * The VideoFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\VideoFormat[]
     */
    public $VideoFormat;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * Constructor method for VideoDescriptionType
     * @uses VideoDescriptionType::setVideoFormat()
     * @uses VideoDescriptionType::setCategory()
     * @param \rdyescapia\StructType\VideoFormat[] $videoFormat
     * @param string $category
     */
    public function __construct(array $videoFormat = array(), $category = null)
    {
        $this
            ->setVideoFormat($videoFormat)
            ->setCategory($category);
    }
    /**
     * Get VideoFormat value
     * @return \rdyescapia\StructType\VideoFormat[]|null
     */
    public function getVideoFormat()
    {
        return $this->VideoFormat;
    }
    /**
     * This method is responsible for validating the values passed to the setVideoFormat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoFormat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVideoFormatForArrayConstraintsFromSetVideoFormat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $videoDescriptionTypeVideoFormatItem) {
            // validation for constraint: itemType
            if (!$videoDescriptionTypeVideoFormatItem instanceof \rdyescapia\StructType\VideoFormat) {
                $invalidValues[] = is_object($videoDescriptionTypeVideoFormatItem) ? get_class($videoDescriptionTypeVideoFormatItem) : sprintf('%s(%s)', gettype($videoDescriptionTypeVideoFormatItem), var_export($videoDescriptionTypeVideoFormatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VideoFormat property can only contain items of type \rdyescapia\StructType\VideoFormat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VideoFormat value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\VideoFormat[] $videoFormat
     * @return \rdyescapia\StructType\VideoDescriptionType
     */
    public function setVideoFormat(array $videoFormat = array())
    {
        // validation for constraint: array
        if ('' !== ($videoFormatArrayErrorMessage = self::validateVideoFormatForArrayConstraintsFromSetVideoFormat($videoFormat))) {
            throw new \InvalidArgumentException($videoFormatArrayErrorMessage, __LINE__);
        }
        $this->VideoFormat = $videoFormat;
        return $this;
    }
    /**
     * Add item to VideoFormat value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\VideoFormat $item
     * @return \rdyescapia\StructType\VideoDescriptionType
     */
    public function addToVideoFormat(\rdyescapia\StructType\VideoFormat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\VideoFormat) {
            throw new \InvalidArgumentException(sprintf('The VideoFormat property can only contain items of type \rdyescapia\StructType\VideoFormat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VideoFormat[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \rdyescapia\StructType\VideoDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
}
