<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehiclePrefType StructType
 * @subpackage Structs
 */
class VehiclePrefType extends VehicleCoreType
{
    /**
     * The TypePref
     * @var string
     */
    public $TypePref;
    /**
     * The ClassPref
     * @var string
     */
    public $ClassPref;
    /**
     * The AirConditionPref
     * @var string
     */
    public $AirConditionPref;
    /**
     * The TransmissionPref
     * @var string
     */
    public $TransmissionPref;
    /**
     * The VendorCarType
     * @var string
     */
    public $VendorCarType;
    /**
     * The VehicleQty
     * @var int
     */
    public $VehicleQty;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for VehiclePrefType
     * @uses VehiclePrefType::setTypePref()
     * @uses VehiclePrefType::setClassPref()
     * @uses VehiclePrefType::setAirConditionPref()
     * @uses VehiclePrefType::setTransmissionPref()
     * @uses VehiclePrefType::setVendorCarType()
     * @uses VehiclePrefType::setVehicleQty()
     * @uses VehiclePrefType::setCode()
     * @uses VehiclePrefType::setCodeContext()
     * @param string $typePref
     * @param string $classPref
     * @param string $airConditionPref
     * @param string $transmissionPref
     * @param string $vendorCarType
     * @param int $vehicleQty
     * @param string $code
     * @param string $codeContext
     */
    public function __construct($typePref = null, $classPref = null, $airConditionPref = null, $transmissionPref = null, $vendorCarType = null, $vehicleQty = null, $code = null, $codeContext = null)
    {
        $this
            ->setTypePref($typePref)
            ->setClassPref($classPref)
            ->setAirConditionPref($airConditionPref)
            ->setTransmissionPref($transmissionPref)
            ->setVendorCarType($vendorCarType)
            ->setVehicleQty($vehicleQty)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get TypePref value
     * @return string|null
     */
    public function getTypePref()
    {
        return $this->TypePref;
    }
    /**
     * Set TypePref value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typePref
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setTypePref($typePref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($typePref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($typePref) ? implode(', ', $typePref) : var_export($typePref, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->TypePref = $typePref;
        return $this;
    }
    /**
     * Get ClassPref value
     * @return string|null
     */
    public function getClassPref()
    {
        return $this->ClassPref;
    }
    /**
     * Set ClassPref value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classPref
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setClassPref($classPref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($classPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($classPref) ? implode(', ', $classPref) : var_export($classPref, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->ClassPref = $classPref;
        return $this;
    }
    /**
     * Get AirConditionPref value
     * @return string|null
     */
    public function getAirConditionPref()
    {
        return $this->AirConditionPref;
    }
    /**
     * Set AirConditionPref value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airConditionPref
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setAirConditionPref($airConditionPref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($airConditionPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($airConditionPref) ? implode(', ', $airConditionPref) : var_export($airConditionPref, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->AirConditionPref = $airConditionPref;
        return $this;
    }
    /**
     * Get TransmissionPref value
     * @return string|null
     */
    public function getTransmissionPref()
    {
        return $this->TransmissionPref;
    }
    /**
     * Set TransmissionPref value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transmissionPref
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setTransmissionPref($transmissionPref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($transmissionPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($transmissionPref) ? implode(', ', $transmissionPref) : var_export($transmissionPref, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->TransmissionPref = $transmissionPref;
        return $this;
    }
    /**
     * Get VendorCarType value
     * @return string|null
     */
    public function getVendorCarType()
    {
        return $this->VendorCarType;
    }
    /**
     * Set VendorCarType value
     * @param string $vendorCarType
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setVendorCarType($vendorCarType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCarType) && !is_string($vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCarType, true), gettype($vendorCarType)), __LINE__);
        }
        $this->VendorCarType = $vendorCarType;
        return $this;
    }
    /**
     * Get VehicleQty value
     * @return int|null
     */
    public function getVehicleQty()
    {
        return $this->VehicleQty;
    }
    /**
     * Set VehicleQty value
     * @param int $vehicleQty
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setVehicleQty($vehicleQty = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleQty) && !(is_int($vehicleQty) || ctype_digit($vehicleQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleQty, true), gettype($vehicleQty)), __LINE__);
        }
        $this->VehicleQty = $vehicleQty;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \rdyescapia\StructType\VehiclePrefType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
}
