<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStayCandidateType StructType
 * @subpackage Structs
 */
class UnitStayCandidateType extends AbstractStructBase
{
    /**
     * The RoomCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfRoomCountType
     */
    public $RoomCounts;
    /**
     * The BedCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfBedCountType
     */
    public $BedCounts;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The PetsPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetsPoliciesType
     */
    public $PetsPolicies;
    /**
     * The NumberFloors
     * @var int
     */
    public $NumberFloors;
    /**
     * The NonSmoking
     * @var bool
     */
    public $NonSmoking;
    /**
     * The AreaSquareFeet
     * @var int
     */
    public $AreaSquareFeet;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The WhenBuilt
     * @var string
     */
    public $WhenBuilt;
    /**
     * Constructor method for UnitStayCandidateType
     * @uses UnitStayCandidateType::setRoomCounts()
     * @uses UnitStayCandidateType::setBedCounts()
     * @uses UnitStayCandidateType::setGuestCounts()
     * @uses UnitStayCandidateType::setPetsPolicies()
     * @uses UnitStayCandidateType::setNumberFloors()
     * @uses UnitStayCandidateType::setNonSmoking()
     * @uses UnitStayCandidateType::setAreaSquareFeet()
     * @uses UnitStayCandidateType::setMaxOccupancy()
     * @uses UnitStayCandidateType::setWhenBuilt()
     * @param \rdyescapia\ArrayType\ArrayOfRoomCountType $roomCounts
     * @param \rdyescapia\ArrayType\ArrayOfBedCountType $bedCounts
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @param \rdyescapia\StructType\PetsPoliciesType $petsPolicies
     * @param int $numberFloors
     * @param bool $nonSmoking
     * @param int $areaSquareFeet
     * @param int $maxOccupancy
     * @param string $whenBuilt
     */
    public function __construct(\rdyescapia\ArrayType\ArrayOfRoomCountType $roomCounts = null, \rdyescapia\ArrayType\ArrayOfBedCountType $bedCounts = null, \rdyescapia\StructType\GuestCountType $guestCounts = null, \rdyescapia\StructType\PetsPoliciesType $petsPolicies = null, $numberFloors = null, $nonSmoking = null, $areaSquareFeet = null, $maxOccupancy = null, $whenBuilt = null)
    {
        $this
            ->setRoomCounts($roomCounts)
            ->setBedCounts($bedCounts)
            ->setGuestCounts($guestCounts)
            ->setPetsPolicies($petsPolicies)
            ->setNumberFloors($numberFloors)
            ->setNonSmoking($nonSmoking)
            ->setAreaSquareFeet($areaSquareFeet)
            ->setMaxOccupancy($maxOccupancy)
            ->setWhenBuilt($whenBuilt);
    }
    /**
     * Get RoomCounts value
     * @return \rdyescapia\ArrayType\ArrayOfRoomCountType|null
     */
    public function getRoomCounts()
    {
        return $this->RoomCounts;
    }
    /**
     * Set RoomCounts value
     * @param \rdyescapia\ArrayType\ArrayOfRoomCountType $roomCounts
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setRoomCounts(\rdyescapia\ArrayType\ArrayOfRoomCountType $roomCounts = null)
    {
        $this->RoomCounts = $roomCounts;
        return $this;
    }
    /**
     * Get BedCounts value
     * @return \rdyescapia\ArrayType\ArrayOfBedCountType|null
     */
    public function getBedCounts()
    {
        return $this->BedCounts;
    }
    /**
     * Set BedCounts value
     * @param \rdyescapia\ArrayType\ArrayOfBedCountType $bedCounts
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setBedCounts(\rdyescapia\ArrayType\ArrayOfBedCountType $bedCounts = null)
    {
        $this->BedCounts = $bedCounts;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapia\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setGuestCounts(\rdyescapia\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get PetsPolicies value
     * @return \rdyescapia\StructType\PetsPoliciesType|null
     */
    public function getPetsPolicies()
    {
        return $this->PetsPolicies;
    }
    /**
     * Set PetsPolicies value
     * @param \rdyescapia\StructType\PetsPoliciesType $petsPolicies
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setPetsPolicies(\rdyescapia\StructType\PetsPoliciesType $petsPolicies = null)
    {
        $this->PetsPolicies = $petsPolicies;
        return $this;
    }
    /**
     * Get NumberFloors value
     * @return int|null
     */
    public function getNumberFloors()
    {
        return $this->NumberFloors;
    }
    /**
     * Set NumberFloors value
     * @param int $numberFloors
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setNumberFloors($numberFloors = null)
    {
        // validation for constraint: int
        if (!is_null($numberFloors) && !(is_int($numberFloors) || ctype_digit($numberFloors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberFloors, true), gettype($numberFloors)), __LINE__);
        }
        $this->NumberFloors = $numberFloors;
        return $this;
    }
    /**
     * Get NonSmoking value
     * @return bool|null
     */
    public function getNonSmoking()
    {
        return $this->NonSmoking;
    }
    /**
     * Set NonSmoking value
     * @param bool $nonSmoking
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setNonSmoking($nonSmoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonSmoking) && !is_bool($nonSmoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonSmoking, true), gettype($nonSmoking)), __LINE__);
        }
        $this->NonSmoking = $nonSmoking;
        return $this;
    }
    /**
     * Get AreaSquareFeet value
     * @return int|null
     */
    public function getAreaSquareFeet()
    {
        return $this->AreaSquareFeet;
    }
    /**
     * Set AreaSquareFeet value
     * @param int $areaSquareFeet
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setAreaSquareFeet($areaSquareFeet = null)
    {
        // validation for constraint: int
        if (!is_null($areaSquareFeet) && !(is_int($areaSquareFeet) || ctype_digit($areaSquareFeet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaSquareFeet, true), gettype($areaSquareFeet)), __LINE__);
        }
        $this->AreaSquareFeet = $areaSquareFeet;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get WhenBuilt value
     * @return string|null
     */
    public function getWhenBuilt()
    {
        return $this->WhenBuilt;
    }
    /**
     * Set WhenBuilt value
     * @param string $whenBuilt
     * @return \rdyescapia\StructType\UnitStayCandidateType
     */
    public function setWhenBuilt($whenBuilt = null)
    {
        // validation for constraint: string
        if (!is_null($whenBuilt) && !is_string($whenBuilt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whenBuilt, true), gettype($whenBuilt)), __LINE__);
        }
        $this->WhenBuilt = $whenBuilt;
        return $this;
    }
}
