<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResRequestType StructType
 * @subpackage Structs
 */
class UnitResRequestType extends EVRN_BaseRQType
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The UnitReservations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * Constructor method for UnitResRequestType
     * @uses UnitResRequestType::setUniqueID()
     * @uses UnitResRequestType::setUnitReservations()
     * @uses UnitResRequestType::setResStatus()
     * @param \rdyescapia\StructType\UniqueID_Type[] $uniqueID
     * @param \rdyescapia\StructType\UnitReservationsType $unitReservations
     * @param string $resStatus
     */
    public function __construct(array $uniqueID = array(), \rdyescapia\StructType\UnitReservationsType $unitReservations = null, $resStatus = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setUnitReservations($unitReservations)
            ->setResStatus($resStatus);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapia\StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitResRequestTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$unitResRequestTypeUniqueIDItem instanceof \rdyescapia\StructType\UniqueID_Type) {
                $invalidValues[] = is_object($unitResRequestTypeUniqueIDItem) ? get_class($unitResRequestTypeUniqueIDItem) : sprintf('%s(%s)', gettype($unitResRequestTypeUniqueIDItem), var_export($unitResRequestTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \rdyescapia\StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UniqueID_Type[] $uniqueID
     * @return \rdyescapia\StructType\UnitResRequestType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UniqueID_Type $item
     * @return \rdyescapia\StructType\UnitResRequestType
     */
    public function addToUniqueID(\rdyescapia\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \rdyescapia\StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapia\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return $this->UnitReservations;
    }
    /**
     * Set UnitReservations value
     * @param \rdyescapia\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapia\StructType\UnitResRequestType
     */
    public function setUnitReservations(\rdyescapia\StructType\UnitReservationsType $unitReservations = null)
    {
        $this->UnitReservations = $unitReservations;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @uses \rdyescapia\EnumType\TransactionActionType::valueIsValid()
     * @uses \rdyescapia\EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resStatus
     * @return \rdyescapia\StructType\UnitResRequestType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\TransactionActionType::valueIsValid($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\TransactionActionType', is_array($resStatus) ? implode(', ', $resStatus) : var_export($resStatus, true), implode(', ', \rdyescapia\EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
}
