<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomAmenityPrefType StructType
 * @subpackage Structs
 */
class RoomAmenityPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The RoomAmenity
     * @var string
     */
    public $RoomAmenity;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The QualityLevel
     * @var string
     */
    public $QualityLevel;
    /**
     * Constructor method for RoomAmenityPrefType
     * @uses RoomAmenityPrefType::set_()
     * @uses RoomAmenityPrefType::setPreferLevel()
     * @uses RoomAmenityPrefType::setRoomAmenity()
     * @uses RoomAmenityPrefType::setExistsCode()
     * @uses RoomAmenityPrefType::setQuantity()
     * @uses RoomAmenityPrefType::setQualityLevel()
     * @param string $_
     * @param string $preferLevel
     * @param string $roomAmenity
     * @param string $existsCode
     * @param int $quantity
     * @param string $qualityLevel
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $roomAmenity = null, $existsCode = null, $quantity = null, $qualityLevel = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setRoomAmenity($roomAmenity)
            ->setExistsCode($existsCode)
            ->setQuantity($quantity)
            ->setQualityLevel($qualityLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \rdyescapia\StructType\RoomAmenityPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\RoomAmenityPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return string|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @param string $roomAmenity
     * @return \rdyescapia\StructType\RoomAmenityPrefType
     */
    public function setRoomAmenity($roomAmenity = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenity) && !is_string($roomAmenity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomAmenity, true), gettype($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \rdyescapia\StructType\RoomAmenityPrefType
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existsCode, true), gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \rdyescapia\StructType\RoomAmenityPrefType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QualityLevel value
     * @return string|null
     */
    public function getQualityLevel()
    {
        return $this->QualityLevel;
    }
    /**
     * Set QualityLevel value
     * @param string $qualityLevel
     * @return \rdyescapia\StructType\RoomAmenityPrefType
     */
    public function setQualityLevel($qualityLevel = null)
    {
        // validation for constraint: string
        if (!is_null($qualityLevel) && !is_string($qualityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualityLevel, true), gettype($qualityLevel)), __LINE__);
        }
        $this->QualityLevel = $qualityLevel;
        return $this;
    }
}
