<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionIdentifierType StructType
 * @subpackage Structs
 */
class RegionIdentifierType extends AbstractStructBase
{
    /**
     * The RegionCode
     * @var int
     */
    public $RegionCode;
    /**
     * The RegionName
     * @var string
     */
    public $RegionName;
    /**
     * The RegionFriendlyName
     * @var string
     */
    public $RegionFriendlyName;
    /**
     * Constructor method for RegionIdentifierType
     * @uses RegionIdentifierType::setRegionCode()
     * @uses RegionIdentifierType::setRegionName()
     * @uses RegionIdentifierType::setRegionFriendlyName()
     * @param int $regionCode
     * @param string $regionName
     * @param string $regionFriendlyName
     */
    public function __construct($regionCode = null, $regionName = null, $regionFriendlyName = null)
    {
        $this
            ->setRegionCode($regionCode)
            ->setRegionName($regionName)
            ->setRegionFriendlyName($regionFriendlyName);
    }
    /**
     * Get RegionCode value
     * @return int|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param int $regionCode
     * @return \rdyescapia\StructType\RegionIdentifierType
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: int
        if (!is_null($regionCode) && !(is_int($regionCode) || ctype_digit($regionCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get RegionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->RegionName;
    }
    /**
     * Set RegionName value
     * @param string $regionName
     * @return \rdyescapia\StructType\RegionIdentifierType
     */
    public function setRegionName($regionName = null)
    {
        // validation for constraint: string
        if (!is_null($regionName) && !is_string($regionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionName, true), gettype($regionName)), __LINE__);
        }
        $this->RegionName = $regionName;
        return $this;
    }
    /**
     * Get RegionFriendlyName value
     * @return string|null
     */
    public function getRegionFriendlyName()
    {
        return $this->RegionFriendlyName;
    }
    /**
     * Set RegionFriendlyName value
     * @param string $regionFriendlyName
     * @return \rdyescapia\StructType\RegionIdentifierType
     */
    public function setRegionFriendlyName($regionFriendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($regionFriendlyName) && !is_string($regionFriendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionFriendlyName, true), gettype($regionFriendlyName)), __LINE__);
        }
        $this->RegionFriendlyName = $regionFriendlyName;
        return $this;
    }
}
