<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreferencesType StructType
 * @subpackage Structs
 */
class PreferencesType extends AbstractStructBase
{
    /**
     * The PrefCollection
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PrefCollection[]
     */
    public $PrefCollection;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for PreferencesType
     * @uses PreferencesType::setPrefCollection()
     * @uses PreferencesType::setShareSynchInd()
     * @uses PreferencesType::setShareMarketInd()
     * @param \rdyescapia\StructType\PrefCollection[] $prefCollection
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $prefCollection = array(), $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setPrefCollection($prefCollection)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get PrefCollection value
     * @return \rdyescapia\StructType\PrefCollection[]|null
     */
    public function getPrefCollection()
    {
        return $this->PrefCollection;
    }
    /**
     * This method is responsible for validating the values passed to the setPrefCollection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrefCollection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrefCollectionForArrayConstraintsFromSetPrefCollection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $preferencesTypePrefCollectionItem) {
            // validation for constraint: itemType
            if (!$preferencesTypePrefCollectionItem instanceof \rdyescapia\StructType\PrefCollection) {
                $invalidValues[] = is_object($preferencesTypePrefCollectionItem) ? get_class($preferencesTypePrefCollectionItem) : sprintf('%s(%s)', gettype($preferencesTypePrefCollectionItem), var_export($preferencesTypePrefCollectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrefCollection property can only contain items of type \rdyescapia\StructType\PrefCollection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrefCollection value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PrefCollection[] $prefCollection
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function setPrefCollection(array $prefCollection = array())
    {
        // validation for constraint: array
        if ('' !== ($prefCollectionArrayErrorMessage = self::validatePrefCollectionForArrayConstraintsFromSetPrefCollection($prefCollection))) {
            throw new \InvalidArgumentException($prefCollectionArrayErrorMessage, __LINE__);
        }
        $this->PrefCollection = $prefCollection;
        return $this;
    }
    /**
     * Add item to PrefCollection value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PrefCollection $item
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function addToPrefCollection(\rdyescapia\StructType\PrefCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PrefCollection) {
            throw new \InvalidArgumentException(sprintf('The PrefCollection property can only contain items of type \rdyescapia\StructType\PrefCollection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrefCollection[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
}
