<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PetsPoliciesType StructType
 * @subpackage Structs
 */
class PetsPoliciesType extends AbstractStructBase
{
    /**
     * The PetsPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetsPolicy[]
     */
    public $PetsPolicy;
    /**
     * The PetsAllowedCode
     * @var string
     */
    public $PetsAllowedCode;
    /**
     * Constructor method for PetsPoliciesType
     * @uses PetsPoliciesType::setPetsPolicy()
     * @uses PetsPoliciesType::setPetsAllowedCode()
     * @param \rdyescapia\StructType\PetsPolicy[] $petsPolicy
     * @param string $petsAllowedCode
     */
    public function __construct(array $petsPolicy = array(), $petsAllowedCode = null)
    {
        $this
            ->setPetsPolicy($petsPolicy)
            ->setPetsAllowedCode($petsAllowedCode);
    }
    /**
     * Get PetsPolicy value
     * @return \rdyescapia\StructType\PetsPolicy[]|null
     */
    public function getPetsPolicy()
    {
        return $this->PetsPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setPetsPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetsPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetsPolicyForArrayConstraintsFromSetPetsPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $petsPoliciesTypePetsPolicyItem) {
            // validation for constraint: itemType
            if (!$petsPoliciesTypePetsPolicyItem instanceof \rdyescapia\StructType\PetsPolicy) {
                $invalidValues[] = is_object($petsPoliciesTypePetsPolicyItem) ? get_class($petsPoliciesTypePetsPolicyItem) : sprintf('%s(%s)', gettype($petsPoliciesTypePetsPolicyItem), var_export($petsPoliciesTypePetsPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetsPolicy property can only contain items of type \rdyescapia\StructType\PetsPolicy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetsPolicy[] $petsPolicy
     * @return \rdyescapia\StructType\PetsPoliciesType
     */
    public function setPetsPolicy(array $petsPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($petsPolicyArrayErrorMessage = self::validatePetsPolicyForArrayConstraintsFromSetPetsPolicy($petsPolicy))) {
            throw new \InvalidArgumentException($petsPolicyArrayErrorMessage, __LINE__);
        }
        $this->PetsPolicy = $petsPolicy;
        return $this;
    }
    /**
     * Add item to PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetsPolicy $item
     * @return \rdyescapia\StructType\PetsPoliciesType
     */
    public function addToPetsPolicy(\rdyescapia\StructType\PetsPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PetsPolicy) {
            throw new \InvalidArgumentException(sprintf('The PetsPolicy property can only contain items of type \rdyescapia\StructType\PetsPolicy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetsPolicy[] = $item;
        return $this;
    }
    /**
     * Get PetsAllowedCode value
     * @return string|null
     */
    public function getPetsAllowedCode()
    {
        return $this->PetsAllowedCode;
    }
    /**
     * Set PetsAllowedCode value
     * @uses \rdyescapia\EnumType\PetsAllowedCodeType::valueIsValid()
     * @uses \rdyescapia\EnumType\PetsAllowedCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $petsAllowedCode
     * @return \rdyescapia\StructType\PetsPoliciesType
     */
    public function setPetsAllowedCode($petsAllowedCode = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PetsAllowedCodeType::valueIsValid($petsAllowedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PetsAllowedCodeType', is_array($petsAllowedCode) ? implode(', ', $petsAllowedCode) : var_export($petsAllowedCode, true), implode(', ', \rdyescapia\EnumType\PetsAllowedCodeType::getValidValues())), __LINE__);
        }
        $this->PetsAllowedCode = $petsAllowedCode;
        return $this;
    }
}
