<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployerType StructType
 * @subpackage Structs
 */
class EmployerType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The RelatedEmployer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType[]
     */
    public $RelatedEmployer;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The InternalRefNmbr
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FreeTextType[]
     */
    public $InternalRefNmbr;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for EmployerType
     * @uses EmployerType::setCompanyName()
     * @uses EmployerType::setRelatedEmployer()
     * @uses EmployerType::setEmployeeInfo()
     * @uses EmployerType::setInternalRefNmbr()
     * @uses EmployerType::setTravelArranger()
     * @uses EmployerType::setLoyaltyProgram()
     * @uses EmployerType::setDefaultInd()
     * @uses EmployerType::setOfficeType()
     * @uses EmployerType::setEffectiveDate()
     * @uses EmployerType::setExpireDate()
     * @param \rdyescapia\StructType\CompanyNameType $companyName
     * @param \rdyescapia\StructType\CompanyNameType[] $relatedEmployer
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @param \rdyescapia\StructType\FreeTextType[] $internalRefNmbr
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @param \rdyescapia\StructType\LoyaltyProgramType[] $loyaltyProgram
     * @param bool $defaultInd
     * @param string $officeType
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\rdyescapia\StructType\CompanyNameType $companyName = null, array $relatedEmployer = array(), array $employeeInfo = array(), array $internalRefNmbr = array(), array $travelArranger = array(), array $loyaltyProgram = array(), $defaultInd = false, $officeType = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setRelatedEmployer($relatedEmployer)
            ->setEmployeeInfo($employeeInfo)
            ->setInternalRefNmbr($internalRefNmbr)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setDefaultInd($defaultInd)
            ->setOfficeType($officeType)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CompanyName value
     * @return \rdyescapia\StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \rdyescapia\StructType\CompanyNameType $companyName
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setCompanyName(\rdyescapia\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get RelatedEmployer value
     * @return \rdyescapia\StructType\CompanyNameType[]|null
     */
    public function getRelatedEmployer()
    {
        return $this->RelatedEmployer;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedEmployer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedEmployer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedEmployerForArrayConstraintsFromSetRelatedEmployer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeRelatedEmployerItem) {
            // validation for constraint: itemType
            if (!$employerTypeRelatedEmployerItem instanceof \rdyescapia\StructType\CompanyNameType) {
                $invalidValues[] = is_object($employerTypeRelatedEmployerItem) ? get_class($employerTypeRelatedEmployerItem) : sprintf('%s(%s)', gettype($employerTypeRelatedEmployerItem), var_export($employerTypeRelatedEmployerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedEmployer property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType[] $relatedEmployer
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setRelatedEmployer(array $relatedEmployer = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedEmployerArrayErrorMessage = self::validateRelatedEmployerForArrayConstraintsFromSetRelatedEmployer($relatedEmployer))) {
            throw new \InvalidArgumentException($relatedEmployerArrayErrorMessage, __LINE__);
        }
        $this->RelatedEmployer = $relatedEmployer;
        return $this;
    }
    /**
     * Add item to RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType $item
     * @return \rdyescapia\StructType\EmployerType
     */
    public function addToRelatedEmployer(\rdyescapia\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedEmployer[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \rdyescapia\StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$employerTypeEmployeeInfoItem instanceof \rdyescapia\StructType\EmployeeInfoType) {
                $invalidValues[] = is_object($employerTypeEmployeeInfoItem) ? get_class($employerTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($employerTypeEmployeeInfoItem), var_export($employerTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type \rdyescapia\StructType\EmployeeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType $item
     * @return \rdyescapia\StructType\EmployerType
     */
    public function addToEmployeeInfo(\rdyescapia\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type \rdyescapia\StructType\EmployeeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get InternalRefNmbr value
     * @return \rdyescapia\StructType\FreeTextType[]|null
     */
    public function getInternalRefNmbr()
    {
        return $this->InternalRefNmbr;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalRefNmbr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalRefNmbr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalRefNmbrForArrayConstraintsFromSetInternalRefNmbr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeInternalRefNmbrItem) {
            // validation for constraint: itemType
            if (!$employerTypeInternalRefNmbrItem instanceof \rdyescapia\StructType\FreeTextType) {
                $invalidValues[] = is_object($employerTypeInternalRefNmbrItem) ? get_class($employerTypeInternalRefNmbrItem) : sprintf('%s(%s)', gettype($employerTypeInternalRefNmbrItem), var_export($employerTypeInternalRefNmbrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InternalRefNmbr property can only contain items of type \rdyescapia\StructType\FreeTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FreeTextType[] $internalRefNmbr
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setInternalRefNmbr(array $internalRefNmbr = array())
    {
        // validation for constraint: array
        if ('' !== ($internalRefNmbrArrayErrorMessage = self::validateInternalRefNmbrForArrayConstraintsFromSetInternalRefNmbr($internalRefNmbr))) {
            throw new \InvalidArgumentException($internalRefNmbrArrayErrorMessage, __LINE__);
        }
        $this->InternalRefNmbr = $internalRefNmbr;
        return $this;
    }
    /**
     * Add item to InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FreeTextType $item
     * @return \rdyescapia\StructType\EmployerType
     */
    public function addToInternalRefNmbr(\rdyescapia\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of type \rdyescapia\StructType\FreeTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InternalRefNmbr[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapia\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$employerTypeTravelArrangerItem instanceof \rdyescapia\StructType\TravelArrangerType) {
                $invalidValues[] = is_object($employerTypeTravelArrangerItem) ? get_class($employerTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($employerTypeTravelArrangerItem), var_export($employerTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type \rdyescapia\StructType\TravelArrangerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType $item
     * @return \rdyescapia\StructType\EmployerType
     */
    public function addToTravelArranger(\rdyescapia\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type \rdyescapia\StructType\TravelArrangerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \rdyescapia\StructType\LoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$employerTypeLoyaltyProgramItem instanceof \rdyescapia\StructType\LoyaltyProgramType) {
                $invalidValues[] = is_object($employerTypeLoyaltyProgramItem) ? get_class($employerTypeLoyaltyProgramItem) : sprintf('%s(%s)', gettype($employerTypeLoyaltyProgramItem), var_export($employerTypeLoyaltyProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgram property can only contain items of type \rdyescapia\StructType\LoyaltyProgramType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyProgramType[] $loyaltyProgram
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramArrayErrorMessage = self::validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram($loyaltyProgram))) {
            throw new \InvalidArgumentException($loyaltyProgramArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyProgramType $item
     * @return \rdyescapia\StructType\EmployerType
     */
    public function addToLoyaltyProgram(\rdyescapia\StructType\LoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\LoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of type \rdyescapia\StructType\LoyaltyProgramType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \rdyescapia\EnumType\OfficeLocationType::valueIsValid()
     * @uses \rdyescapia\EnumType\OfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\OfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\OfficeLocationType', is_array($officeType) ? implode(', ', $officeType) : var_export($officeType, true), implode(', ', \rdyescapia\EnumType\OfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapia\StructType\EmployerType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
}
