<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPersonType StructType
 * @subpackage Structs
 */
class ContactPersonType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressInfoType[]
     */
    public $Address;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmailType[]
     */
    public $Email;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\URL_Type[]
     */
    public $URL;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType[]
     */
    public $CompanyName;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The ContactType
     * @var string
     */
    public $ContactType;
    /**
     * The Relation
     * @var string
     */
    public $Relation;
    /**
     * The EmergencyFlag
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $EmergencyFlag;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for ContactPersonType
     * @uses ContactPersonType::setPersonName()
     * @uses ContactPersonType::setTelephone()
     * @uses ContactPersonType::setAddress()
     * @uses ContactPersonType::setEmail()
     * @uses ContactPersonType::setURL()
     * @uses ContactPersonType::setCompanyName()
     * @uses ContactPersonType::setEmployeeInfo()
     * @uses ContactPersonType::setShareSynchInd()
     * @uses ContactPersonType::setShareMarketInd()
     * @uses ContactPersonType::setDefaultInd()
     * @uses ContactPersonType::setContactType()
     * @uses ContactPersonType::setRelation()
     * @uses ContactPersonType::setEmergencyFlag()
     * @uses ContactPersonType::setRPH()
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @param \rdyescapia\StructType\Telephone[] $telephone
     * @param \rdyescapia\StructType\AddressInfoType[] $address
     * @param \rdyescapia\StructType\EmailType[] $email
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @param \rdyescapia\StructType\CompanyNameType[] $companyName
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $defaultInd
     * @param string $contactType
     * @param string $relation
     * @param bool $emergencyFlag
     * @param string $rPH
     */
    public function __construct(\rdyescapia\StructType\PersonNameType $personName = null, array $telephone = array(), array $address = array(), array $email = array(), array $uRL = array(), array $companyName = array(), array $employeeInfo = array(), $shareSynchInd = null, $shareMarketInd = null, $defaultInd = false, $contactType = null, $relation = null, $emergencyFlag = false, $rPH = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setAddress($address)
            ->setEmail($email)
            ->setURL($uRL)
            ->setCompanyName($companyName)
            ->setEmployeeInfo($employeeInfo)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDefaultInd($defaultInd)
            ->setContactType($contactType)
            ->setRelation($relation)
            ->setEmergencyFlag($emergencyFlag)
            ->setRPH($rPH);
    }
    /**
     * Get PersonName value
     * @return \rdyescapia\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setPersonName(\rdyescapia\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \rdyescapia\StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeTelephoneItem instanceof \rdyescapia\StructType\Telephone) {
                $invalidValues[] = is_object($contactPersonTypeTelephoneItem) ? get_class($contactPersonTypeTelephoneItem) : sprintf('%s(%s)', gettype($contactPersonTypeTelephoneItem), var_export($contactPersonTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \rdyescapia\StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Telephone[] $telephone
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Telephone $item
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function addToTelephone(\rdyescapia\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \rdyescapia\StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapia\StructType\AddressInfoType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeAddressItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeAddressItem instanceof \rdyescapia\StructType\AddressInfoType) {
                $invalidValues[] = is_object($contactPersonTypeAddressItem) ? get_class($contactPersonTypeAddressItem) : sprintf('%s(%s)', gettype($contactPersonTypeAddressItem), var_export($contactPersonTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \rdyescapia\StructType\AddressInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressInfoType[] $address
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressInfoType $item
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function addToAddress(\rdyescapia\StructType\AddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \rdyescapia\StructType\AddressInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapia\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeEmailItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeEmailItem instanceof \rdyescapia\StructType\EmailType) {
                $invalidValues[] = is_object($contactPersonTypeEmailItem) ? get_class($contactPersonTypeEmailItem) : sprintf('%s(%s)', gettype($contactPersonTypeEmailItem), var_export($contactPersonTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \rdyescapia\StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType[] $email
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType $item
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function addToEmail(\rdyescapia\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \rdyescapia\StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \rdyescapia\StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeURLItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeURLItem instanceof \rdyescapia\StructType\URL_Type) {
                $invalidValues[] = is_object($contactPersonTypeURLItem) ? get_class($contactPersonTypeURLItem) : sprintf('%s(%s)', gettype($contactPersonTypeURLItem), var_export($contactPersonTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \rdyescapia\StructType\URL_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type $item
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function addToURL(\rdyescapia\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \rdyescapia\StructType\URL_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return \rdyescapia\StructType\CompanyNameType[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyNameForArrayConstraintsFromSetCompanyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeCompanyNameItem instanceof \rdyescapia\StructType\CompanyNameType) {
                $invalidValues[] = is_object($contactPersonTypeCompanyNameItem) ? get_class($contactPersonTypeCompanyNameItem) : sprintf('%s(%s)', gettype($contactPersonTypeCompanyNameItem), var_export($contactPersonTypeCompanyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompanyName property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType[] $companyName
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setCompanyName(array $companyName = array())
    {
        // validation for constraint: array
        if ('' !== ($companyNameArrayErrorMessage = self::validateCompanyNameForArrayConstraintsFromSetCompanyName($companyName))) {
            throw new \InvalidArgumentException($companyNameArrayErrorMessage, __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType $item
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function addToCompanyName(\rdyescapia\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \rdyescapia\StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeEmployeeInfoItem instanceof \rdyescapia\StructType\EmployeeInfoType) {
                $invalidValues[] = is_object($contactPersonTypeEmployeeInfoItem) ? get_class($contactPersonTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($contactPersonTypeEmployeeInfoItem), var_export($contactPersonTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type \rdyescapia\StructType\EmployeeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType $item
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function addToEmployeeInfo(\rdyescapia\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type \rdyescapia\StructType\EmployeeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param string $contactType
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: string
        if (!is_null($contactType) && !is_string($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactType, true), gettype($contactType)), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get Relation value
     * @return string|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relation, true), gettype($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get EmergencyFlag value
     * @return bool|null
     */
    public function getEmergencyFlag()
    {
        return $this->EmergencyFlag;
    }
    /**
     * Set EmergencyFlag value
     * @param bool $emergencyFlag
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setEmergencyFlag($emergencyFlag = false)
    {
        // validation for constraint: boolean
        if (!is_null($emergencyFlag) && !is_bool($emergencyFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emergencyFlag, true), gettype($emergencyFlag)), __LINE__);
        }
        $this->EmergencyFlag = $emergencyFlag;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapia\StructType\ContactPersonType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
}
