<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinPref StructType
 * @subpackage Structs
 */
class CabinPref extends AbstractStructBase
{
    /**
     * The Cabin
     * @var string
     */
    public $Cabin;
    /**
     * Constructor method for CabinPref
     * @uses CabinPref::setCabin()
     * @param string $cabin
     */
    public function __construct($cabin = null)
    {
        $this
            ->setCabin($cabin);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \rdyescapia\EnumType\CabinType::valueIsValid()
     * @uses \rdyescapia\EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \rdyescapia\StructType\CabinPref
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\CabinType::valueIsValid($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\CabinType', is_array($cabin) ? implode(', ', $cabin) : var_export($cabin, true), implode(', ', \rdyescapia\EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
}
