<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharges StructType
 * @subpackage Structs
 */
class AdditionalCharges extends AbstractStructBase
{
    /**
     * The AdditionalCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AdditionalChargeType[]
     */
    public $AdditionalCharge;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The OptionalChargesIndicator
     * @var string
     */
    public $OptionalChargesIndicator;
    /**
     * Constructor method for AdditionalCharges
     * @uses AdditionalCharges::setAdditionalCharge()
     * @uses AdditionalCharges::setAmountBeforeTax()
     * @uses AdditionalCharges::setAmountAfterTax()
     * @uses AdditionalCharges::setCurrencyCode()
     * @uses AdditionalCharges::setDecimalPlaces()
     * @uses AdditionalCharges::setOptionalChargesIndicator()
     * @param \rdyescapia\StructType\AdditionalChargeType[] $additionalCharge
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $optionalChargesIndicator
     */
    public function __construct(array $additionalCharge = array(), $amountBeforeTax = null, $amountAfterTax = null, $currencyCode = null, $decimalPlaces = null, $optionalChargesIndicator = null)
    {
        $this
            ->setAdditionalCharge($additionalCharge)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setOptionalChargesIndicator($optionalChargesIndicator);
    }
    /**
     * Get AdditionalCharge value
     * @return \rdyescapia\StructType\AdditionalChargeType[]|null
     */
    public function getAdditionalCharge()
    {
        return $this->AdditionalCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalChargeForArrayConstraintsFromSetAdditionalCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalChargesAdditionalChargeItem) {
            // validation for constraint: itemType
            if (!$additionalChargesAdditionalChargeItem instanceof \rdyescapia\StructType\AdditionalChargeType) {
                $invalidValues[] = is_object($additionalChargesAdditionalChargeItem) ? get_class($additionalChargesAdditionalChargeItem) : sprintf('%s(%s)', gettype($additionalChargesAdditionalChargeItem), var_export($additionalChargesAdditionalChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalCharge property can only contain items of type \rdyescapia\StructType\AdditionalChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AdditionalChargeType[] $additionalCharge
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function setAdditionalCharge(array $additionalCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalChargeArrayErrorMessage = self::validateAdditionalChargeForArrayConstraintsFromSetAdditionalCharge($additionalCharge))) {
            throw new \InvalidArgumentException($additionalChargeArrayErrorMessage, __LINE__);
        }
        $this->AdditionalCharge = $additionalCharge;
        return $this;
    }
    /**
     * Add item to AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AdditionalChargeType $item
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function addToAdditionalCharge(\rdyescapia\StructType\AdditionalChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AdditionalChargeType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalCharge property can only contain items of type \rdyescapia\StructType\AdditionalChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalCharge[] = $item;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountBeforeTax) && !(is_float($amountBeforeTax) || is_numeric($amountBeforeTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountBeforeTax, true), gettype($amountBeforeTax)), __LINE__);
        }
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTax) && !(is_float($amountAfterTax) || is_numeric($amountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTax, true), gettype($amountAfterTax)), __LINE__);
        }
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get OptionalChargesIndicator value
     * @return string|null
     */
    public function getOptionalChargesIndicator()
    {
        return $this->OptionalChargesIndicator;
    }
    /**
     * Set OptionalChargesIndicator value
     * @param string $optionalChargesIndicator
     * @return \rdyescapia\StructType\AdditionalCharges
     */
    public function setOptionalChargesIndicator($optionalChargesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($optionalChargesIndicator) && !is_string($optionalChargesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionalChargesIndicator, true), gettype($optionalChargesIndicator)), __LINE__);
        }
        $this->OptionalChargesIndicator = $optionalChargesIndicator;
        return $this;
    }
}
