<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Access StructType
 * @subpackage Structs
 */
class Access extends AbstractStructBase
{
    /**
     * The AccessPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonNameType
     */
    public $AccessPerson;
    /**
     * The AccessComment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FreeTextType
     */
    public $AccessComment;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ActionDateTime
     * @var string
     */
    public $ActionDateTime;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for Access
     * @uses Access::setAccessPerson()
     * @uses Access::setAccessComment()
     * @uses Access::setActionType()
     * @uses Access::setActionDateTime()
     * @uses Access::setID()
     * @param \rdyescapia\StructType\PersonNameType $accessPerson
     * @param \rdyescapia\StructType\FreeTextType $accessComment
     * @param string $actionType
     * @param string $actionDateTime
     * @param string $iD
     */
    public function __construct(\rdyescapia\StructType\PersonNameType $accessPerson = null, \rdyescapia\StructType\FreeTextType $accessComment = null, $actionType = null, $actionDateTime = null, $iD = null)
    {
        $this
            ->setAccessPerson($accessPerson)
            ->setAccessComment($accessComment)
            ->setActionType($actionType)
            ->setActionDateTime($actionDateTime)
            ->setID($iD);
    }
    /**
     * Get AccessPerson value
     * @return \rdyescapia\StructType\PersonNameType|null
     */
    public function getAccessPerson()
    {
        return $this->AccessPerson;
    }
    /**
     * Set AccessPerson value
     * @param \rdyescapia\StructType\PersonNameType $accessPerson
     * @return \rdyescapia\StructType\Access
     */
    public function setAccessPerson(\rdyescapia\StructType\PersonNameType $accessPerson = null)
    {
        $this->AccessPerson = $accessPerson;
        return $this;
    }
    /**
     * Get AccessComment value
     * @return \rdyescapia\StructType\FreeTextType|null
     */
    public function getAccessComment()
    {
        return $this->AccessComment;
    }
    /**
     * Set AccessComment value
     * @param \rdyescapia\StructType\FreeTextType $accessComment
     * @return \rdyescapia\StructType\Access
     */
    public function setAccessComment(\rdyescapia\StructType\FreeTextType $accessComment = null)
    {
        $this->AccessComment = $accessComment;
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @param string $actionType
     * @return \rdyescapia\StructType\Access
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ActionDateTime value
     * @return string|null
     */
    public function getActionDateTime()
    {
        return $this->ActionDateTime;
    }
    /**
     * Set ActionDateTime value
     * @param string $actionDateTime
     * @return \rdyescapia\StructType\Access
     */
    public function setActionDateTime($actionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actionDateTime) && !is_string($actionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDateTime, true), gettype($actionDateTime)), __LINE__);
        }
        $this->ActionDateTime = $actionDateTime;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \rdyescapia\StructType\Access
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
}
