<?php

namespace rdyescapia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Property ServiceType
 * @subpackage Services
 */
class Property extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PropertyManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_PropertyManagerRQ $eVRN_PropertyManagerRQ
     * @return \rdyescapia\StructType\EVRN_PropertyManagerRS|bool
     */
    public function PropertyManager(\rdyescapia\StructType\EVRN_PropertyManagerRQ $eVRN_PropertyManagerRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->PropertyManager($eVRN_PropertyManagerRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \rdyescapia\StructType\EVRN_PropertyManagerRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
