<?php

namespace rdyescapia\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FlightTypeType EnumType
 * @subpackage Enumerations
 */
class FlightTypeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Nonstop'
     * @return string 'Nonstop'
     */
    const VALUE_NONSTOP = 'Nonstop';
    /**
     * Constant for value 'Direct'
     * @return string 'Direct'
     */
    const VALUE_DIRECT = 'Direct';
    /**
     * Constant for value 'Connection'
     * @return string 'Connection'
     */
    const VALUE_CONNECTION = 'Connection';
    /**
     * Constant for value 'SingleConnection'
     * @return string 'SingleConnection'
     */
    const VALUE_SINGLE_CONNECTION = 'SingleConnection';
    /**
     * Constant for value 'DoubleConnection'
     * @return string 'DoubleConnection'
     */
    const VALUE_DOUBLE_CONNECTION = 'DoubleConnection';
    /**
     * Return allowed values
     * @uses self::VALUE_NONSTOP
     * @uses self::VALUE_DIRECT
     * @uses self::VALUE_CONNECTION
     * @uses self::VALUE_SINGLE_CONNECTION
     * @uses self::VALUE_DOUBLE_CONNECTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONSTOP,
            self::VALUE_DIRECT,
            self::VALUE_CONNECTION,
            self::VALUE_SINGLE_CONNECTION,
            self::VALUE_DOUBLE_CONNECTION,
        );
    }
}
