<?php

namespace rdyescapia\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ActionType EnumType
 * @subpackage Enumerations
 */
class ActionType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Create'
     * @return string 'Create'
     */
    const VALUE_CREATE = 'Create';
    /**
     * Constant for value 'Read'
     * @return string 'Read'
     */
    const VALUE_READ = 'Read';
    /**
     * Constant for value 'Update'
     * @return string 'Update'
     */
    const VALUE_UPDATE = 'Update';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Add-Update'
     * @return string 'Add-Update'
     */
    const VALUE_ADD_UPDATE = 'Add-Update';
    /**
     * Constant for value 'Cancel'
     * @return string 'Cancel'
     */
    const VALUE_CANCEL = 'Cancel';
    /**
     * Constant for value 'Add'
     * @return string 'Add'
     */
    const VALUE_ADD = 'Add';
    /**
     * Constant for value 'Replace'
     * @return string 'Replace'
     */
    const VALUE_REPLACE = 'Replace';
    /**
     * Return allowed values
     * @uses self::VALUE_CREATE
     * @uses self::VALUE_READ
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_ADD_UPDATE
     * @uses self::VALUE_CANCEL
     * @uses self::VALUE_ADD
     * @uses self::VALUE_REPLACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATE,
            self::VALUE_READ,
            self::VALUE_UPDATE,
            self::VALUE_DELETE,
            self::VALUE_ADD_UPDATE,
            self::VALUE_CANCEL,
            self::VALUE_ADD,
            self::VALUE_REPLACE,
        );
    }
}
