<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialRequestTypeSpecialRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfSpecialRequestTypeSpecialRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for ArrayOfSpecialRequestTypeSpecialRequest
     * @uses ArrayOfSpecialRequestTypeSpecialRequest::setSpecialRequest()
     * @param \rdyescapia\StructType\SpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * @return \rdyescapia\StructType\SpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialRequestForArrayConstraintsFromSetSpecialRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem instanceof \rdyescapia\StructType\SpecialRequest) {
                $invalidValues[] = is_object($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) ? get_class($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) : sprintf('%s(%s)', gettype($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem), var_export($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialRequest property can only contain items of type \rdyescapia\StructType\SpecialRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecialRequest[] $specialRequest
     * @return \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($specialRequestArrayErrorMessage = self::validateSpecialRequestForArrayConstraintsFromSetSpecialRequest($specialRequest))) {
            throw new \InvalidArgumentException($specialRequestArrayErrorMessage, __LINE__);
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecialRequest $item
     * @return \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public function addToSpecialRequest(\rdyescapia\StructType\SpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of type \rdyescapia\StructType\SpecialRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialRequest
     */
    public function getAttributeName()
    {
        return 'SpecialRequest';
    }
}
