<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReservationUpdateUnitRate ArrayType
 * @subpackage Arrays
 */
class ArrayOfReservationUpdateUnitRate extends AbstractStructArrayBase
{
    /**
     * The UnitRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitRate[]
     */
    public $UnitRate;
    /**
     * Constructor method for ArrayOfReservationUpdateUnitRate
     * @uses ArrayOfReservationUpdateUnitRate::setUnitRate()
     * @param \rdyescapia\StructType\UnitRate[] $unitRate
     */
    public function __construct(array $unitRate = array())
    {
        $this
            ->setUnitRate($unitRate);
    }
    /**
     * Get UnitRate value
     * @return \rdyescapia\StructType\UnitRate[]|null
     */
    public function getUnitRate()
    {
        return $this->UnitRate;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitRateForArrayConstraintsFromSetUnitRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReservationUpdateUnitRateUnitRateItem) {
            // validation for constraint: itemType
            if (!$arrayOfReservationUpdateUnitRateUnitRateItem instanceof \rdyescapia\StructType\UnitRate) {
                $invalidValues[] = is_object($arrayOfReservationUpdateUnitRateUnitRateItem) ? get_class($arrayOfReservationUpdateUnitRateUnitRateItem) : sprintf('%s(%s)', gettype($arrayOfReservationUpdateUnitRateUnitRateItem), var_export($arrayOfReservationUpdateUnitRateUnitRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitRate property can only contain items of type \rdyescapia\StructType\UnitRate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitRate value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitRate[] $unitRate
     * @return \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate
     */
    public function setUnitRate(array $unitRate = array())
    {
        // validation for constraint: array
        if ('' !== ($unitRateArrayErrorMessage = self::validateUnitRateForArrayConstraintsFromSetUnitRate($unitRate))) {
            throw new \InvalidArgumentException($unitRateArrayErrorMessage, __LINE__);
        }
        $this->UnitRate = $unitRate;
        return $this;
    }
    /**
     * Add item to UnitRate value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitRate $item
     * @return \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate
     */
    public function addToUnitRate(\rdyescapia\StructType\UnitRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitRate) {
            throw new \InvalidArgumentException(sprintf('The UnitRate property can only contain items of type \rdyescapia\StructType\UnitRate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitRate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\UnitRate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\UnitRate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\UnitRate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\UnitRate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\UnitRate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UnitRate
     */
    public function getAttributeName()
    {
        return 'UnitRate';
    }
}
