<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInquiryRequestType ArrayType
 * @subpackage Arrays
 */
class ArrayOfInquiryRequestType extends AbstractStructArrayBase
{
    /**
     * The InquiryRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\InquiryRequestType[]
     */
    public $InquiryRequest;
    /**
     * Constructor method for ArrayOfInquiryRequestType
     * @uses ArrayOfInquiryRequestType::setInquiryRequest()
     * @param \rdyescapia\StructType\InquiryRequestType[] $inquiryRequest
     */
    public function __construct(array $inquiryRequest = array())
    {
        $this
            ->setInquiryRequest($inquiryRequest);
    }
    /**
     * Get InquiryRequest value
     * @return \rdyescapia\StructType\InquiryRequestType[]|null
     */
    public function getInquiryRequest()
    {
        return $this->InquiryRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setInquiryRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInquiryRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInquiryRequestForArrayConstraintsFromSetInquiryRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInquiryRequestTypeInquiryRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfInquiryRequestTypeInquiryRequestItem instanceof \rdyescapia\StructType\InquiryRequestType) {
                $invalidValues[] = is_object($arrayOfInquiryRequestTypeInquiryRequestItem) ? get_class($arrayOfInquiryRequestTypeInquiryRequestItem) : sprintf('%s(%s)', gettype($arrayOfInquiryRequestTypeInquiryRequestItem), var_export($arrayOfInquiryRequestTypeInquiryRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InquiryRequest property can only contain items of type \rdyescapia\StructType\InquiryRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InquiryRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InquiryRequestType[] $inquiryRequest
     * @return \rdyescapia\ArrayType\ArrayOfInquiryRequestType
     */
    public function setInquiryRequest(array $inquiryRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($inquiryRequestArrayErrorMessage = self::validateInquiryRequestForArrayConstraintsFromSetInquiryRequest($inquiryRequest))) {
            throw new \InvalidArgumentException($inquiryRequestArrayErrorMessage, __LINE__);
        }
        $this->InquiryRequest = $inquiryRequest;
        return $this;
    }
    /**
     * Add item to InquiryRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InquiryRequestType $item
     * @return \rdyescapia\ArrayType\ArrayOfInquiryRequestType
     */
    public function addToInquiryRequest(\rdyescapia\StructType\InquiryRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\InquiryRequestType) {
            throw new \InvalidArgumentException(sprintf('The InquiryRequest property can only contain items of type \rdyescapia\StructType\InquiryRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InquiryRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InquiryRequest
     */
    public function getAttributeName()
    {
        return 'InquiryRequest';
    }
}
