<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The SeriesCode
     * @var string
     */
    public $SeriesCode;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setSeriesCode()
     * @param string $seriesCode
     */
    public function __construct($seriesCode = null)
    {
        $this
            ->setSeriesCode($seriesCode);
    }
    /**
     * Get SeriesCode value
     * @return string|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param string $seriesCode
     * @return \rdyescapia\StructType\Voucher
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: string
        if (!is_null($seriesCode) && !is_string($seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesCode, true), gettype($seriesCode)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
}
