<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoFormat StructType
 * @subpackage Structs
 */
class VideoFormat extends VideoItemType
{
    /**
     * The ContentID
     * @var string
     */
    public $ContentID;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Author
     * @var string
     */
    public $Author;
    /**
     * The CopyrightNotice
     * @var string
     */
    public $CopyrightNotice;
    /**
     * The CopyrightOwner
     * @var string
     */
    public $CopyrightOwner;
    /**
     * The CopyrightStart
     * @var string
     */
    public $CopyrightStart;
    /**
     * The CopyrightEnd
     * @var string
     */
    public $CopyrightEnd;
    /**
     * The EffectiveStart
     * @var string
     */
    public $EffectiveStart;
    /**
     * The EffectiveEnd
     * @var string
     */
    public $EffectiveEnd;
    /**
     * The ApplicableStart
     * @var string
     */
    public $ApplicableStart;
    /**
     * The ApplicableEnd
     * @var string
     */
    public $ApplicableEnd;
    /**
     * The RecordID
     * @var string
     */
    public $RecordID;
    /**
     * Constructor method for VideoFormat
     * @uses VideoFormat::setContentID()
     * @uses VideoFormat::setTitle()
     * @uses VideoFormat::setAuthor()
     * @uses VideoFormat::setCopyrightNotice()
     * @uses VideoFormat::setCopyrightOwner()
     * @uses VideoFormat::setCopyrightStart()
     * @uses VideoFormat::setCopyrightEnd()
     * @uses VideoFormat::setEffectiveStart()
     * @uses VideoFormat::setEffectiveEnd()
     * @uses VideoFormat::setApplicableStart()
     * @uses VideoFormat::setApplicableEnd()
     * @uses VideoFormat::setRecordID()
     * @param string $contentID
     * @param string $title
     * @param string $author
     * @param string $copyrightNotice
     * @param string $copyrightOwner
     * @param string $copyrightStart
     * @param string $copyrightEnd
     * @param string $effectiveStart
     * @param string $effectiveEnd
     * @param string $applicableStart
     * @param string $applicableEnd
     * @param string $recordID
     */
    public function __construct($contentID = null, $title = null, $author = null, $copyrightNotice = null, $copyrightOwner = null, $copyrightStart = null, $copyrightEnd = null, $effectiveStart = null, $effectiveEnd = null, $applicableStart = null, $applicableEnd = null, $recordID = null)
    {
        $this
            ->setContentID($contentID)
            ->setTitle($title)
            ->setAuthor($author)
            ->setCopyrightNotice($copyrightNotice)
            ->setCopyrightOwner($copyrightOwner)
            ->setCopyrightStart($copyrightStart)
            ->setCopyrightEnd($copyrightEnd)
            ->setEffectiveStart($effectiveStart)
            ->setEffectiveEnd($effectiveEnd)
            ->setApplicableStart($applicableStart)
            ->setApplicableEnd($applicableEnd)
            ->setRecordID($recordID);
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setContentID($contentID = null)
    {
        // validation for constraint: string
        if (!is_null($contentID) && !is_string($contentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentID, true), gettype($contentID)), __LINE__);
        }
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get CopyrightNotice value
     * @return string|null
     */
    public function getCopyrightNotice()
    {
        return $this->CopyrightNotice;
    }
    /**
     * Set CopyrightNotice value
     * @param string $copyrightNotice
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setCopyrightNotice($copyrightNotice = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightNotice) && !is_string($copyrightNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightNotice, true), gettype($copyrightNotice)), __LINE__);
        }
        $this->CopyrightNotice = $copyrightNotice;
        return $this;
    }
    /**
     * Get CopyrightOwner value
     * @return string|null
     */
    public function getCopyrightOwner()
    {
        return $this->CopyrightOwner;
    }
    /**
     * Set CopyrightOwner value
     * @param string $copyrightOwner
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setCopyrightOwner($copyrightOwner = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightOwner) && !is_string($copyrightOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightOwner, true), gettype($copyrightOwner)), __LINE__);
        }
        $this->CopyrightOwner = $copyrightOwner;
        return $this;
    }
    /**
     * Get CopyrightStart value
     * @return string|null
     */
    public function getCopyrightStart()
    {
        return $this->CopyrightStart;
    }
    /**
     * Set CopyrightStart value
     * @param string $copyrightStart
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setCopyrightStart($copyrightStart = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightStart) && !is_string($copyrightStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightStart, true), gettype($copyrightStart)), __LINE__);
        }
        $this->CopyrightStart = $copyrightStart;
        return $this;
    }
    /**
     * Get CopyrightEnd value
     * @return string|null
     */
    public function getCopyrightEnd()
    {
        return $this->CopyrightEnd;
    }
    /**
     * Set CopyrightEnd value
     * @param string $copyrightEnd
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setCopyrightEnd($copyrightEnd = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightEnd) && !is_string($copyrightEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightEnd, true), gettype($copyrightEnd)), __LINE__);
        }
        $this->CopyrightEnd = $copyrightEnd;
        return $this;
    }
    /**
     * Get EffectiveStart value
     * @return string|null
     */
    public function getEffectiveStart()
    {
        return $this->EffectiveStart;
    }
    /**
     * Set EffectiveStart value
     * @param string $effectiveStart
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setEffectiveStart($effectiveStart = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStart) && !is_string($effectiveStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStart, true), gettype($effectiveStart)), __LINE__);
        }
        $this->EffectiveStart = $effectiveStart;
        return $this;
    }
    /**
     * Get EffectiveEnd value
     * @return string|null
     */
    public function getEffectiveEnd()
    {
        return $this->EffectiveEnd;
    }
    /**
     * Set EffectiveEnd value
     * @param string $effectiveEnd
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setEffectiveEnd($effectiveEnd = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEnd) && !is_string($effectiveEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEnd, true), gettype($effectiveEnd)), __LINE__);
        }
        $this->EffectiveEnd = $effectiveEnd;
        return $this;
    }
    /**
     * Get ApplicableStart value
     * @return string|null
     */
    public function getApplicableStart()
    {
        return $this->ApplicableStart;
    }
    /**
     * Set ApplicableStart value
     * @param string $applicableStart
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setApplicableStart($applicableStart = null)
    {
        // validation for constraint: string
        if (!is_null($applicableStart) && !is_string($applicableStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableStart, true), gettype($applicableStart)), __LINE__);
        }
        $this->ApplicableStart = $applicableStart;
        return $this;
    }
    /**
     * Get ApplicableEnd value
     * @return string|null
     */
    public function getApplicableEnd()
    {
        return $this->ApplicableEnd;
    }
    /**
     * Set ApplicableEnd value
     * @param string $applicableEnd
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setApplicableEnd($applicableEnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableEnd) && !is_string($applicableEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableEnd, true), gettype($applicableEnd)), __LINE__);
        }
        $this->ApplicableEnd = $applicableEnd;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \rdyescapia\StructType\VideoFormat
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
}
