<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationType StructType
 * @subpackage Structs
 */
class VerificationType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonName
     */
    public $PersonName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmailType
     */
    public $Email;
    /**
     * The TelephoneInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TelephoneInfo
     */
    public $TelephoneInfo;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressInfoType
     */
    public $AddressInfo;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType[]
     */
    public $Vendor;
    /**
     * The ReservationTimeSpan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ReservationTimeSpan
     */
    public $ReservationTimeSpan;
    /**
     * The AssociatedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AssociatedQuantity[]
     */
    public $AssociatedQuantity;
    /**
     * The StartLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\StartLocation
     */
    public $StartLocation;
    /**
     * The EndLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EndLocation
     */
    public $EndLocation;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VerificationType
     * @uses VerificationType::setPersonName()
     * @uses VerificationType::setEmail()
     * @uses VerificationType::setTelephoneInfo()
     * @uses VerificationType::setPaymentCard()
     * @uses VerificationType::setAddressInfo()
     * @uses VerificationType::setCustLoyalty()
     * @uses VerificationType::setVendor()
     * @uses VerificationType::setReservationTimeSpan()
     * @uses VerificationType::setAssociatedQuantity()
     * @uses VerificationType::setStartLocation()
     * @uses VerificationType::setEndLocation()
     * @uses VerificationType::setTPA_Extensions()
     * @param \rdyescapia\StructType\PersonName $personName
     * @param \rdyescapia\StructType\EmailType $email
     * @param \rdyescapia\StructType\TelephoneInfo $telephoneInfo
     * @param \rdyescapia\StructType\PaymentCardType $paymentCard
     * @param \rdyescapia\StructType\AddressInfoType $addressInfo
     * @param \rdyescapia\StructType\CustLoyalty[] $custLoyalty
     * @param \rdyescapia\StructType\CompanyNameType[] $vendor
     * @param \rdyescapia\StructType\ReservationTimeSpan $reservationTimeSpan
     * @param \rdyescapia\StructType\AssociatedQuantity[] $associatedQuantity
     * @param \rdyescapia\StructType\StartLocation $startLocation
     * @param \rdyescapia\StructType\EndLocation $endLocation
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     */
    public function __construct(\rdyescapia\StructType\PersonName $personName = null, \rdyescapia\StructType\EmailType $email = null, \rdyescapia\StructType\TelephoneInfo $telephoneInfo = null, \rdyescapia\StructType\PaymentCardType $paymentCard = null, \rdyescapia\StructType\AddressInfoType $addressInfo = null, array $custLoyalty = array(), array $vendor = array(), \rdyescapia\StructType\ReservationTimeSpan $reservationTimeSpan = null, array $associatedQuantity = array(), \rdyescapia\StructType\StartLocation $startLocation = null, \rdyescapia\StructType\EndLocation $endLocation = null, \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this
            ->setPersonName($personName)
            ->setEmail($email)
            ->setTelephoneInfo($telephoneInfo)
            ->setPaymentCard($paymentCard)
            ->setAddressInfo($addressInfo)
            ->setCustLoyalty($custLoyalty)
            ->setVendor($vendor)
            ->setReservationTimeSpan($reservationTimeSpan)
            ->setAssociatedQuantity($associatedQuantity)
            ->setStartLocation($startLocation)
            ->setEndLocation($endLocation)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get PersonName value
     * @return \rdyescapia\StructType\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapia\StructType\PersonName $personName
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setPersonName(\rdyescapia\StructType\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapia\StructType\EmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \rdyescapia\StructType\EmailType $email
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setEmail(\rdyescapia\StructType\EmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \rdyescapia\StructType\TelephoneInfo|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * Set TelephoneInfo value
     * @param \rdyescapia\StructType\TelephoneInfo $telephoneInfo
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setTelephoneInfo(\rdyescapia\StructType\TelephoneInfo $telephoneInfo = null)
    {
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \rdyescapia\StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \rdyescapia\StructType\PaymentCardType $paymentCard
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setPaymentCard(\rdyescapia\StructType\PaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \rdyescapia\StructType\AddressInfoType|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param \rdyescapia\StructType\AddressInfoType $addressInfo
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setAddressInfo(\rdyescapia\StructType\AddressInfoType $addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \rdyescapia\StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$verificationTypeCustLoyaltyItem instanceof \rdyescapia\StructType\CustLoyalty) {
                $invalidValues[] = is_object($verificationTypeCustLoyaltyItem) ? get_class($verificationTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($verificationTypeCustLoyaltyItem), var_export($verificationTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \rdyescapia\StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustLoyalty[] $custLoyalty
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustLoyalty $item
     * @return \rdyescapia\StructType\VerificationType
     */
    public function addToCustLoyalty(\rdyescapia\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \rdyescapia\StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \rdyescapia\StructType\CompanyNameType[]|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * This method is responsible for validating the values passed to the setVendor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorForArrayConstraintsFromSetVendor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationTypeVendorItem) {
            // validation for constraint: itemType
            if (!$verificationTypeVendorItem instanceof \rdyescapia\StructType\CompanyNameType) {
                $invalidValues[] = is_object($verificationTypeVendorItem) ? get_class($verificationTypeVendorItem) : sprintf('%s(%s)', gettype($verificationTypeVendorItem), var_export($verificationTypeVendorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vendor property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vendor value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType[] $vendor
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setVendor(array $vendor = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorArrayErrorMessage = self::validateVendorForArrayConstraintsFromSetVendor($vendor))) {
            throw new \InvalidArgumentException($vendorArrayErrorMessage, __LINE__);
        }
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Add item to Vendor value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType $item
     * @return \rdyescapia\StructType\VerificationType
     */
    public function addToVendor(\rdyescapia\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Vendor property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vendor[] = $item;
        return $this;
    }
    /**
     * Get ReservationTimeSpan value
     * @return \rdyescapia\StructType\ReservationTimeSpan|null
     */
    public function getReservationTimeSpan()
    {
        return $this->ReservationTimeSpan;
    }
    /**
     * Set ReservationTimeSpan value
     * @param \rdyescapia\StructType\ReservationTimeSpan $reservationTimeSpan
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setReservationTimeSpan(\rdyescapia\StructType\ReservationTimeSpan $reservationTimeSpan = null)
    {
        $this->ReservationTimeSpan = $reservationTimeSpan;
        return $this;
    }
    /**
     * Get AssociatedQuantity value
     * @return \rdyescapia\StructType\AssociatedQuantity[]|null
     */
    public function getAssociatedQuantity()
    {
        return $this->AssociatedQuantity;
    }
    /**
     * This method is responsible for validating the values passed to the setAssociatedQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssociatedQuantityForArrayConstraintsFromSetAssociatedQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationTypeAssociatedQuantityItem) {
            // validation for constraint: itemType
            if (!$verificationTypeAssociatedQuantityItem instanceof \rdyescapia\StructType\AssociatedQuantity) {
                $invalidValues[] = is_object($verificationTypeAssociatedQuantityItem) ? get_class($verificationTypeAssociatedQuantityItem) : sprintf('%s(%s)', gettype($verificationTypeAssociatedQuantityItem), var_export($verificationTypeAssociatedQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssociatedQuantity property can only contain items of type \rdyescapia\StructType\AssociatedQuantity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AssociatedQuantity[] $associatedQuantity
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setAssociatedQuantity(array $associatedQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($associatedQuantityArrayErrorMessage = self::validateAssociatedQuantityForArrayConstraintsFromSetAssociatedQuantity($associatedQuantity))) {
            throw new \InvalidArgumentException($associatedQuantityArrayErrorMessage, __LINE__);
        }
        $this->AssociatedQuantity = $associatedQuantity;
        return $this;
    }
    /**
     * Add item to AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AssociatedQuantity $item
     * @return \rdyescapia\StructType\VerificationType
     */
    public function addToAssociatedQuantity(\rdyescapia\StructType\AssociatedQuantity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AssociatedQuantity) {
            throw new \InvalidArgumentException(sprintf('The AssociatedQuantity property can only contain items of type \rdyescapia\StructType\AssociatedQuantity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssociatedQuantity[] = $item;
        return $this;
    }
    /**
     * Get StartLocation value
     * @return \rdyescapia\StructType\StartLocation|null
     */
    public function getStartLocation()
    {
        return $this->StartLocation;
    }
    /**
     * Set StartLocation value
     * @param \rdyescapia\StructType\StartLocation $startLocation
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setStartLocation(\rdyescapia\StructType\StartLocation $startLocation = null)
    {
        $this->StartLocation = $startLocation;
        return $this;
    }
    /**
     * Get EndLocation value
     * @return \rdyescapia\StructType\EndLocation|null
     */
    public function getEndLocation()
    {
        return $this->EndLocation;
    }
    /**
     * Set EndLocation value
     * @param \rdyescapia\StructType\EndLocation $endLocation
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setEndLocation(\rdyescapia\StructType\EndLocation $endLocation = null)
    {
        $this->EndLocation = $endLocation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\VerificationType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
}
