<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveContents StructType
 * @subpackage Structs
 */
class UnitDescriptiveContents extends AbstractStructBase
{
    /**
     * The UnitDescriptiveContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitDescriptiveContentType[]
     */
    public $UnitDescriptiveContent;
    /**
     * The CachedData
     * @var bool
     */
    public $CachedData;
    /**
     * Constructor method for UnitDescriptiveContents
     * @uses UnitDescriptiveContents::setUnitDescriptiveContent()
     * @uses UnitDescriptiveContents::setCachedData()
     * @param \rdyescapia\StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @param bool $cachedData
     */
    public function __construct(array $unitDescriptiveContent = array(), $cachedData = null)
    {
        $this
            ->setUnitDescriptiveContent($unitDescriptiveContent)
            ->setCachedData($cachedData);
    }
    /**
     * Get UnitDescriptiveContent value
     * @return \rdyescapia\StructType\UnitDescriptiveContentType[]|null
     */
    public function getUnitDescriptiveContent()
    {
        return $this->UnitDescriptiveContent;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitDescriptiveContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitDescriptiveContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitDescriptiveContentForArrayConstraintsFromSetUnitDescriptiveContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitDescriptiveContentsUnitDescriptiveContentItem) {
            // validation for constraint: itemType
            if (!$unitDescriptiveContentsUnitDescriptiveContentItem instanceof \rdyescapia\StructType\UnitDescriptiveContentType) {
                $invalidValues[] = is_object($unitDescriptiveContentsUnitDescriptiveContentItem) ? get_class($unitDescriptiveContentsUnitDescriptiveContentItem) : sprintf('%s(%s)', gettype($unitDescriptiveContentsUnitDescriptiveContentItem), var_export($unitDescriptiveContentsUnitDescriptiveContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitDescriptiveContent property can only contain items of type \rdyescapia\StructType\UnitDescriptiveContentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public function setUnitDescriptiveContent(array $unitDescriptiveContent = array())
    {
        // validation for constraint: array
        if ('' !== ($unitDescriptiveContentArrayErrorMessage = self::validateUnitDescriptiveContentForArrayConstraintsFromSetUnitDescriptiveContent($unitDescriptiveContent))) {
            throw new \InvalidArgumentException($unitDescriptiveContentArrayErrorMessage, __LINE__);
        }
        $this->UnitDescriptiveContent = $unitDescriptiveContent;
        return $this;
    }
    /**
     * Add item to UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitDescriptiveContentType $item
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public function addToUnitDescriptiveContent(\rdyescapia\StructType\UnitDescriptiveContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitDescriptiveContentType) {
            throw new \InvalidArgumentException(sprintf('The UnitDescriptiveContent property can only contain items of type \rdyescapia\StructType\UnitDescriptiveContentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitDescriptiveContent[] = $item;
        return $this;
    }
    /**
     * Get CachedData value
     * @return bool|null
     */
    public function getCachedData()
    {
        return $this->CachedData;
    }
    /**
     * Set CachedData value
     * @param bool $cachedData
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public function setCachedData($cachedData = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedData) && !is_bool($cachedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cachedData, true), gettype($cachedData)), __LINE__);
        }
        $this->CachedData = $cachedData;
        return $this;
    }
}
