<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextItemsType StructType
 * @subpackage Structs
 */
class TextItemsType extends AbstractStructBase
{
    /**
     * The TextItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TextItem[]
     */
    public $TextItem;
    /**
     * The MoreData
     * @var bool
     */
    public $MoreData;
    /**
     * Constructor method for TextItemsType
     * @uses TextItemsType::setTextItem()
     * @uses TextItemsType::setMoreData()
     * @param \rdyescapia\StructType\TextItem[] $textItem
     * @param bool $moreData
     */
    public function __construct(array $textItem = array(), $moreData = null)
    {
        $this
            ->setTextItem($textItem)
            ->setMoreData($moreData);
    }
    /**
     * Get TextItem value
     * @return \rdyescapia\StructType\TextItem[]|null
     */
    public function getTextItem()
    {
        return $this->TextItem;
    }
    /**
     * This method is responsible for validating the values passed to the setTextItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextItemForArrayConstraintsFromSetTextItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textItemsTypeTextItemItem) {
            // validation for constraint: itemType
            if (!$textItemsTypeTextItemItem instanceof \rdyescapia\StructType\TextItem) {
                $invalidValues[] = is_object($textItemsTypeTextItemItem) ? get_class($textItemsTypeTextItemItem) : sprintf('%s(%s)', gettype($textItemsTypeTextItemItem), var_export($textItemsTypeTextItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TextItem property can only contain items of type \rdyescapia\StructType\TextItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TextItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TextItem[] $textItem
     * @return \rdyescapia\StructType\TextItemsType
     */
    public function setTextItem(array $textItem = array())
    {
        // validation for constraint: array
        if ('' !== ($textItemArrayErrorMessage = self::validateTextItemForArrayConstraintsFromSetTextItem($textItem))) {
            throw new \InvalidArgumentException($textItemArrayErrorMessage, __LINE__);
        }
        $this->TextItem = $textItem;
        return $this;
    }
    /**
     * Add item to TextItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TextItem $item
     * @return \rdyescapia\StructType\TextItemsType
     */
    public function addToTextItem(\rdyescapia\StructType\TextItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TextItem) {
            throw new \InvalidArgumentException(sprintf('The TextItem property can only contain items of type \rdyescapia\StructType\TextItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TextItem[] = $item;
        return $this;
    }
    /**
     * Get MoreData value
     * @return bool|null
     */
    public function getMoreData()
    {
        return $this->MoreData;
    }
    /**
     * Set MoreData value
     * @param bool $moreData
     * @return \rdyescapia\StructType\TextItemsType
     */
    public function setMoreData($moreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreData) && !is_bool($moreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreData, true), gettype($moreData)), __LINE__);
        }
        $this->MoreData = $moreData;
        return $this;
    }
}
