<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestorID StructType
 * @subpackage Structs
 */
class RequestorID extends AbstractStructBase
{
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The MessagePassword
     * @var string
     */
    public $MessagePassword;
    /**
     * Constructor method for RequestorID
     * @uses RequestorID::setID()
     * @uses RequestorID::setMessagePassword()
     * @param string $iD
     * @param string $messagePassword
     */
    public function __construct($iD = null, $messagePassword = null)
    {
        $this
            ->setID($iD)
            ->setMessagePassword($messagePassword);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \rdyescapia\StructType\RequestorID
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get MessagePassword value
     * @return string|null
     */
    public function getMessagePassword()
    {
        return $this->MessagePassword;
    }
    /**
     * Set MessagePassword value
     * @param string $messagePassword
     * @return \rdyescapia\StructType\RequestorID
     */
    public function setMessagePassword($messagePassword = null)
    {
        // validation for constraint: string
        if (!is_null($messagePassword) && !is_string($messagePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messagePassword, true), gettype($messagePassword)), __LINE__);
        }
        $this->MessagePassword = $messagePassword;
        return $this;
    }
}
