<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrgMemberName StructType
 * @subpackage Structs
 */
class OrgMemberName extends PersonNameType
{
    /**
     * The Level
     * @var string
     */
    public $Level;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * Constructor method for OrgMemberName
     * @uses OrgMemberName::setLevel()
     * @uses OrgMemberName::setTitle()
     * @param string $level
     * @param string $title
     */
    public function __construct($level = null, $title = null)
    {
        $this
            ->setLevel($level)
            ->setTitle($title);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param string $level
     * @return \rdyescapia\StructType\OrgMemberName
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \rdyescapia\StructType\OrgMemberName
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
}
