<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamePrefType StructType
 * @subpackage Structs
 */
class NamePrefType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for NamePrefType
     * @uses NamePrefType::setUniqueID()
     * @uses NamePrefType::setPersonName()
     * @uses NamePrefType::setPreferLevel()
     * @param \rdyescapia\StructType\UniqueID_Type $uniqueID
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @param string $preferLevel
     */
    public function __construct(\rdyescapia\StructType\UniqueID_Type $uniqueID = null, \rdyescapia\StructType\PersonNameType $personName = null, $preferLevel = 'Preferred')
    {
        $this
            ->setUniqueID($uniqueID)
            ->setPersonName($personName)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapia\StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \rdyescapia\StructType\UniqueID_Type $uniqueID
     * @return \rdyescapia\StructType\NamePrefType
     */
    public function setUniqueID(\rdyescapia\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \rdyescapia\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @return \rdyescapia\StructType\NamePrefType
     */
    public function setPersonName(\rdyescapia\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\NamePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
}
