<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageDescriptionType StructType
 * @subpackage Structs
 */
class ImageDescriptionType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ImageFormat[]
     */
    public $ImageFormat;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Description[]
     */
    public $Description;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * Constructor method for ImageDescriptionType
     * @uses ImageDescriptionType::setImageFormat()
     * @uses ImageDescriptionType::setDescription()
     * @uses ImageDescriptionType::setCategory()
     * @param \rdyescapia\StructType\ImageFormat[] $imageFormat
     * @param \rdyescapia\StructType\Description[] $description
     * @param string $category
     */
    public function __construct(array $imageFormat = array(), array $description = array(), $category = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setDescription($description)
            ->setCategory($category);
    }
    /**
     * Get ImageFormat value
     * @return \rdyescapia\StructType\ImageFormat[]|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * This method is responsible for validating the values passed to the setImageFormat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageFormat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageFormatForArrayConstraintsFromSetImageFormat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imageDescriptionTypeImageFormatItem) {
            // validation for constraint: itemType
            if (!$imageDescriptionTypeImageFormatItem instanceof \rdyescapia\StructType\ImageFormat) {
                $invalidValues[] = is_object($imageDescriptionTypeImageFormatItem) ? get_class($imageDescriptionTypeImageFormatItem) : sprintf('%s(%s)', gettype($imageDescriptionTypeImageFormatItem), var_export($imageDescriptionTypeImageFormatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageFormat property can only contain items of type \rdyescapia\StructType\ImageFormat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageFormat value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ImageFormat[] $imageFormat
     * @return \rdyescapia\StructType\ImageDescriptionType
     */
    public function setImageFormat(array $imageFormat = array())
    {
        // validation for constraint: array
        if ('' !== ($imageFormatArrayErrorMessage = self::validateImageFormatForArrayConstraintsFromSetImageFormat($imageFormat))) {
            throw new \InvalidArgumentException($imageFormatArrayErrorMessage, __LINE__);
        }
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Add item to ImageFormat value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ImageFormat $item
     * @return \rdyescapia\StructType\ImageDescriptionType
     */
    public function addToImageFormat(\rdyescapia\StructType\ImageFormat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ImageFormat) {
            throw new \InvalidArgumentException(sprintf('The ImageFormat property can only contain items of type \rdyescapia\StructType\ImageFormat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageFormat[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \rdyescapia\StructType\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imageDescriptionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$imageDescriptionTypeDescriptionItem instanceof \rdyescapia\StructType\Description) {
                $invalidValues[] = is_object($imageDescriptionTypeDescriptionItem) ? get_class($imageDescriptionTypeDescriptionItem) : sprintf('%s(%s)', gettype($imageDescriptionTypeDescriptionItem), var_export($imageDescriptionTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \rdyescapia\StructType\Description, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Description[] $description
     * @return \rdyescapia\StructType\ImageDescriptionType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Description $item
     * @return \rdyescapia\StructType\ImageDescriptionType
     */
    public function addToDescription(\rdyescapia\StructType\Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \rdyescapia\StructType\Description, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \rdyescapia\StructType\ImageDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
}
