<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountType StructType
 * @subpackage Structs
 */
class DiscountType extends TotalType
{
    /**
     * The DiscountReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ParagraphType
     */
    public $DiscountReason;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The DiscountCode
     * @var string
     */
    public $DiscountCode;
    /**
     * Constructor method for DiscountType
     * @uses DiscountType::setDiscountReason()
     * @uses DiscountType::setTaxInclusive()
     * @uses DiscountType::setPercent()
     * @uses DiscountType::setDiscountCode()
     * @param \rdyescapia\StructType\ParagraphType $discountReason
     * @param bool $taxInclusive
     * @param float $percent
     * @param string $discountCode
     */
    public function __construct(\rdyescapia\StructType\ParagraphType $discountReason = null, $taxInclusive = null, $percent = null, $discountCode = null)
    {
        $this
            ->setDiscountReason($discountReason)
            ->setTaxInclusive($taxInclusive)
            ->setPercent($percent)
            ->setDiscountCode($discountCode);
    }
    /**
     * Get DiscountReason value
     * @return \rdyescapia\StructType\ParagraphType|null
     */
    public function getDiscountReason()
    {
        return $this->DiscountReason;
    }
    /**
     * Set DiscountReason value
     * @param \rdyescapia\StructType\ParagraphType $discountReason
     * @return \rdyescapia\StructType\DiscountType
     */
    public function setDiscountReason(\rdyescapia\StructType\ParagraphType $discountReason = null)
    {
        $this->DiscountReason = $discountReason;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \rdyescapia\StructType\DiscountType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \rdyescapia\StructType\DiscountType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \rdyescapia\StructType\DiscountType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
}
