<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Description StructType
 * @subpackage Structs
 */
class Description extends FormattedTextTextType
{
    /**
     * The _
     * @var \rdyescapia\StructType\FormattedTextTextType
     */
    public $_;
    /**
     * The Caption
     * @var string
     */
    public $Caption;
    /**
     * The ListItem
     * @var int
     */
    public $ListItem;
    /**
     * Constructor method for Description
     * @uses Description::set_()
     * @uses Description::setCaption()
     * @uses Description::setListItem()
     * @param \rdyescapia\StructType\FormattedTextTextType $_
     * @param string $caption
     * @param int $listItem
     */
    public function __construct(\rdyescapia\StructType\FormattedTextTextType $_ = null, $caption = null, $listItem = null)
    {
        $this
            ->set_($_)
            ->setCaption($caption)
            ->setListItem($listItem);
    }
    /**
     * Get _ value
     * @return \rdyescapia\StructType\FormattedTextTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \rdyescapia\StructType\FormattedTextTextType $_
     * @return \rdyescapia\StructType\Description
     */
    public function set_(\rdyescapia\StructType\FormattedTextTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \rdyescapia\StructType\Description
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ListItem value
     * @return int|null
     */
    public function getListItem()
    {
        return $this->ListItem;
    }
    /**
     * Set ListItem value
     * @param int $listItem
     * @return \rdyescapia\StructType\Description
     */
    public function setListItem($listItem = null)
    {
        // validation for constraint: int
        if (!is_null($listItem) && !(is_int($listItem) || ctype_digit($listItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listItem, true), gettype($listItem)), __LINE__);
        }
        $this->ListItem = $listItem;
        return $this;
    }
}
