<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The VendorCode
     * @var string[]
     */
    public $VendorCode;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setTravelSector()
     * @uses CustLoyalty::setRPH()
     * @uses CustLoyalty::setVendorCode()
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $rPH
     * @param string[] $vendorCode
     */
    public function __construct($programID = null, $membershipID = null, $travelSector = null, $rPH = null, array $vendorCode = array())
    {
        $this
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setRPH($rPH)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorCodeForArrayConstraintsFromSetVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $custLoyaltyVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($custLoyaltyVendorCodeItem)) {
                $invalidValues[] = is_object($custLoyaltyVendorCodeItem) ? get_class($custLoyaltyVendorCodeItem) : sprintf('%s(%s)', gettype($custLoyaltyVendorCodeItem), var_export($custLoyaltyVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $vendorCode
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setVendorCode(array $vendorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorCodeArrayErrorMessage = self::validateVendorCodeForArrayConstraintsFromSetVendorCode($vendorCode))) {
            throw new \InvalidArgumentException($vendorCodeArrayErrorMessage, __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Add item to VendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function addToVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorCode[] = $item;
        return $this;
    }
}
