<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * @subpackage Structs
 */
class Comment extends ParagraphType
{
    /**
     * The CommentOriginatorCode
     * @var string
     */
    public $CommentOriginatorCode;
    /**
     * The GuestViewable
     * @var bool
     */
    public $GuestViewable;
    /**
     * Constructor method for Comment
     * @uses Comment::setCommentOriginatorCode()
     * @uses Comment::setGuestViewable()
     * @param string $commentOriginatorCode
     * @param bool $guestViewable
     */
    public function __construct($commentOriginatorCode = null, $guestViewable = null)
    {
        $this
            ->setCommentOriginatorCode($commentOriginatorCode)
            ->setGuestViewable($guestViewable);
    }
    /**
     * Get CommentOriginatorCode value
     * @return string|null
     */
    public function getCommentOriginatorCode()
    {
        return $this->CommentOriginatorCode;
    }
    /**
     * Set CommentOriginatorCode value
     * @param string $commentOriginatorCode
     * @return \rdyescapia\StructType\Comment
     */
    public function setCommentOriginatorCode($commentOriginatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($commentOriginatorCode) && !is_string($commentOriginatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentOriginatorCode, true), gettype($commentOriginatorCode)), __LINE__);
        }
        $this->CommentOriginatorCode = $commentOriginatorCode;
        return $this;
    }
    /**
     * Get GuestViewable value
     * @return bool|null
     */
    public function getGuestViewable()
    {
        return $this->GuestViewable;
    }
    /**
     * Set GuestViewable value
     * @param bool $guestViewable
     * @return \rdyescapia\StructType\Comment
     */
    public function setGuestViewable($guestViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($guestViewable) && !is_bool($guestViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guestViewable, true), gettype($guestViewable)), __LINE__);
        }
        $this->GuestViewable = $guestViewable;
        return $this;
    }
}
