<?php

namespace rdyescapia\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PetsAllowedCodeType EnumType
 * @subpackage Enumerations
 */
class PetsAllowedCodeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Pets Allowed'
     * @return string 'Pets Allowed'
     */
    const VALUE_PETS_ALLOWED = 'Pets Allowed';
    /**
     * Constant for value 'Pets Not Allowed'
     * @return string 'Pets Not Allowed'
     */
    const VALUE_PETS_NOT_ALLOWED = 'Pets Not Allowed';
    /**
     * Constant for value 'Assistive Animals Only'
     * @return string 'Assistive Animals Only'
     */
    const VALUE_ASSISTIVE_ANIMALS_ONLY = 'Assistive Animals Only';
    /**
     * Constant for value 'Pets By Arrangements'
     * @return string 'Pets By Arrangements'
     */
    const VALUE_PETS_BY_ARRANGEMENTS = 'Pets By Arrangements';
    /**
     * Return allowed values
     * @uses self::VALUE_PETS_ALLOWED
     * @uses self::VALUE_PETS_NOT_ALLOWED
     * @uses self::VALUE_ASSISTIVE_ANIMALS_ONLY
     * @uses self::VALUE_PETS_BY_ARRANGEMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PETS_ALLOWED,
            self::VALUE_PETS_NOT_ALLOWED,
            self::VALUE_ASSISTIVE_ANIMALS_ONLY,
            self::VALUE_PETS_BY_ARRANGEMENTS,
        );
    }
}
