<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBedCountType ArrayType
 * @subpackage Arrays
 */
class ArrayOfBedCountType extends AbstractStructArrayBase
{
    /**
     * The BedCount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\BedCountType[]
     */
    public $BedCount;
    /**
     * Constructor method for ArrayOfBedCountType
     * @uses ArrayOfBedCountType::setBedCount()
     * @param \rdyescapia\StructType\BedCountType[] $bedCount
     */
    public function __construct(array $bedCount = array())
    {
        $this
            ->setBedCount($bedCount);
    }
    /**
     * Get BedCount value
     * @return \rdyescapia\StructType\BedCountType[]|null
     */
    public function getBedCount()
    {
        return $this->BedCount;
    }
    /**
     * This method is responsible for validating the values passed to the setBedCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedCountForArrayConstraintsFromSetBedCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBedCountTypeBedCountItem) {
            // validation for constraint: itemType
            if (!$arrayOfBedCountTypeBedCountItem instanceof \rdyescapia\StructType\BedCountType) {
                $invalidValues[] = is_object($arrayOfBedCountTypeBedCountItem) ? get_class($arrayOfBedCountTypeBedCountItem) : sprintf('%s(%s)', gettype($arrayOfBedCountTypeBedCountItem), var_export($arrayOfBedCountTypeBedCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BedCount property can only contain items of type \rdyescapia\StructType\BedCountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BedCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\BedCountType[] $bedCount
     * @return \rdyescapia\ArrayType\ArrayOfBedCountType
     */
    public function setBedCount(array $bedCount = array())
    {
        // validation for constraint: array
        if ('' !== ($bedCountArrayErrorMessage = self::validateBedCountForArrayConstraintsFromSetBedCount($bedCount))) {
            throw new \InvalidArgumentException($bedCountArrayErrorMessage, __LINE__);
        }
        $this->BedCount = $bedCount;
        return $this;
    }
    /**
     * Add item to BedCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\BedCountType $item
     * @return \rdyescapia\ArrayType\ArrayOfBedCountType
     */
    public function addToBedCount(\rdyescapia\StructType\BedCountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\BedCountType) {
            throw new \InvalidArgumentException(sprintf('The BedCount property can only contain items of type \rdyescapia\StructType\BedCountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BedCount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\BedCountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\BedCountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\BedCountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\BedCountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\BedCountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BedCount
     */
    public function getAttributeName()
    {
        return 'BedCount';
    }
}
