<?php

namespace EnumType;

/**
 * This class stands for UrlType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UrlType
 * @subpackage Enumerations
 */
class UrlType
{
    /**
     * Constant for value 'Kategori'
     * @return string 'Kategori'
     */
    const VALUE_KATEGORI = 'Kategori';
    /**
     * Constant for value 'Marka'
     * @return string 'Marka'
     */
    const VALUE_MARKA = 'Marka';
    /**
     * Constant for value 'Urun'
     * @return string 'Urun'
     */
    const VALUE_URUN = 'Urun';
    /**
     * Constant for value 'Tedarikci'
     * @return string 'Tedarikci'
     */
    const VALUE_TEDARIKCI = 'Tedarikci';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KATEGORI
     * @uses self::VALUE_MARKA
     * @uses self::VALUE_URUN
     * @uses self::VALUE_TEDARIKCI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KATEGORI,
            self::VALUE_MARKA,
            self::VALUE_URUN,
            self::VALUE_TEDARIKCI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
