<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Select ServiceType
 * @subpackage Services
 */
class Select extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SelectKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectKategori $parameters
     * @return \StructType\SelectKategoriResponse|bool
     */
    public function SelectKategori(\StructType\SelectKategori $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectMarka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectMarka $parameters
     * @return \StructType\SelectMarkaResponse|bool
     */
    public function SelectMarka(\StructType\SelectMarka $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectMarka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTedarikci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTedarikci $parameters
     * @return \StructType\SelectTedarikciResponse|bool
     */
    public function SelectTedarikci(\StructType\SelectTedarikci $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectTedarikci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectEtiket $parameters
     * @return \StructType\SelectEtiketResponse|bool
     */
    public function SelectEtiket(\StructType\SelectEtiket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectParaBirimi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectParaBirimi $parameters
     * @return \StructType\SelectParaBirimiResponse|bool
     */
    public function SelectParaBirimi(\StructType\SelectParaBirimi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectParaBirimi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTeknikDetayGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTeknikDetayGrup $parameters
     * @return \StructType\SelectTeknikDetayGrupResponse|bool
     */
    public function SelectTeknikDetayGrup(\StructType\SelectTeknikDetayGrup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectTeknikDetayGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTeknikDetayOzellik
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTeknikDetayOzellik $parameters
     * @return \StructType\SelectTeknikDetayOzellikResponse|bool
     */
    public function SelectTeknikDetayOzellik(\StructType\SelectTeknikDetayOzellik $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectTeknikDetayOzellik($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTeknikDetayDeger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTeknikDetayDeger $parameters
     * @return \StructType\SelectTeknikDetayDegerResponse|bool
     */
    public function SelectTeknikDetayDeger(\StructType\SelectTeknikDetayDeger $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectTeknikDetayDeger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectAsortiGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectAsortiGrup $parameters
     * @return \StructType\SelectAsortiGrupResponse|bool
     */
    public function SelectAsortiGrup(\StructType\SelectAsortiGrup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectAsortiGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectAsortiMiktar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectAsortiMiktar $parameters
     * @return \StructType\SelectAsortiMiktarResponse|bool
     */
    public function SelectAsortiMiktar(\StructType\SelectAsortiMiktar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectAsortiMiktar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEkSecenekGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectEkSecenekGrup $parameters
     * @return \StructType\SelectEkSecenekGrupResponse|bool
     */
    public function SelectEkSecenekGrup(\StructType\SelectEkSecenekGrup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectEkSecenekGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEkSecenekDeger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectEkSecenekDeger $parameters
     * @return \StructType\SelectEkSecenekDegerResponse|bool
     */
    public function SelectEkSecenekDeger(\StructType\SelectEkSecenekDeger $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectEkSecenekDeger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrun $parameters
     * @return \StructType\SelectUrunResponse|bool
     */
    public function SelectUrun(\StructType\SelectUrun $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunCount $parameters
     * @return \StructType\SelectUrunCountResponse|bool
     */
    public function SelectUrunCount(\StructType\SelectUrunCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectUrunCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectVaryasyon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectVaryasyon $parameters
     * @return \StructType\SelectVaryasyonResponse|bool
     */
    public function SelectVaryasyon(\StructType\SelectVaryasyon $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectVaryasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectVaryasyonCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectVaryasyonCount $parameters
     * @return \StructType\SelectVaryasyonCountResponse|bool
     */
    public function SelectVaryasyonCount(\StructType\SelectVaryasyonCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectVaryasyonCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunOdemeSecenek
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunOdemeSecenek $parameters
     * @return \StructType\SelectUrunOdemeSecenekResponse|bool
     */
    public function SelectUrunOdemeSecenek(\StructType\SelectUrunOdemeSecenek $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectUrunOdemeSecenek($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunYorum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunYorum $parameters
     * @return \StructType\SelectUrunYorumResponse|bool
     */
    public function SelectUrunYorum(\StructType\SelectUrunYorum $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectUrunYorum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunKategori $parameters
     * @return \StructType\SelectUrunKategoriResponse|bool
     */
    public function SelectUrunKategori(\StructType\SelectUrunKategori $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SelectUrunKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SelectAsortiGrupResponse|\StructType\SelectAsortiMiktarResponse|\StructType\SelectEkSecenekDegerResponse|\StructType\SelectEkSecenekGrupResponse|\StructType\SelectEtiketResponse|\StructType\SelectKategoriResponse|\StructType\SelectMarkaResponse|\StructType\SelectParaBirimiResponse|\StructType\SelectTedarikciResponse|\StructType\SelectTeknikDetayDegerResponse|\StructType\SelectTeknikDetayGrupResponse|\StructType\SelectTeknikDetayOzellikResponse|\StructType\SelectUrunCountResponse|\StructType\SelectUrunKategoriResponse|\StructType\SelectUrunOdemeSecenekResponse|\StructType\SelectUrunResponse|\StructType\SelectUrunYorumResponse|\StructType\SelectVaryasyonCountResponse|\StructType\SelectVaryasyonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
