<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKategori ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfKategori
 * @subpackage Arrays
 */
class ArrayOfKategori extends AbstractStructArrayBase
{
    /**
     * The Kategori
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Kategori[]
     */
    public $Kategori;
    /**
     * Constructor method for ArrayOfKategori
     * @uses ArrayOfKategori::setKategori()
     * @param \StructType\Kategori[] $kategori
     */
    public function __construct(array $kategori = array())
    {
        $this
            ->setKategori($kategori);
    }
    /**
     * Get Kategori value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Kategori[]|null
     */
    public function getKategori()
    {
        return isset($this->Kategori) ? $this->Kategori : null;
    }
    /**
     * Set Kategori value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Kategori[] $kategori
     * @return \ArrayType\ArrayOfKategori
     */
    public function setKategori(array $kategori = array())
    {
        foreach ($kategori as $arrayOfKategoriKategoriItem) {
            // validation for constraint: itemType
            if (!$arrayOfKategoriKategoriItem instanceof \StructType\Kategori) {
                throw new \InvalidArgumentException(sprintf('The Kategori property can only contain items of \StructType\Kategori, "%s" given', is_object($arrayOfKategoriKategoriItem) ? get_class($arrayOfKategoriKategoriItem) : gettype($arrayOfKategoriKategoriItem)), __LINE__);
            }
        }
        if (is_null($kategori) || (is_array($kategori) && empty($kategori))) {
            unset($this->Kategori);
        } else {
            $this->Kategori = $kategori;
        }
        return $this;
    }
    /**
     * Add item to Kategori value
     * @throws \InvalidArgumentException
     * @param \StructType\Kategori $item
     * @return \ArrayType\ArrayOfKategori
     */
    public function addToKategori(\StructType\Kategori $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kategori) {
            throw new \InvalidArgumentException(sprintf('The Kategori property can only contain items of \StructType\Kategori, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Kategori[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Kategori|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Kategori|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Kategori|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Kategori|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Kategori|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Kategori
     */
    public function getAttributeName()
    {
        return 'Kategori';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfKategori
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
