<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeOrders StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeOrders
 * @subpackage Structs
 */
class StoreOrders extends AbstractStructBase
{
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - documentation: Contains the whole data for the shipments.
     * - maxOccurs: 30
     * - minOccurs: 1
     * @var \cycro\StructType\ShipmentServiceData[]
     */
    public $order;
    /**
     * The printOptions
     * Meta informations extracted from the WSDL
     * - documentation: The Options which should be used for parcel printing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \cycro\StructType\PrintOptions
     */
    public $printOptions;
    /**
     * Constructor method for storeOrders
     * @uses StoreOrders::setOrder()
     * @uses StoreOrders::setPrintOptions()
     * @param \cycro\StructType\ShipmentServiceData[] $order
     * @param \cycro\StructType\PrintOptions $printOptions
     */
    public function __construct(array $order = array(), \cycro\StructType\PrintOptions $printOptions = null)
    {
        $this
            ->setOrder($order)
            ->setPrintOptions($printOptions);
    }
    /**
     * Get order value
     * @return \cycro\StructType\ShipmentServiceData[]
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ShipmentServiceData[] $order
     * @return \cycro\StructType\StoreOrders
     */
    public function setOrder(array $order = array())
    {
        foreach ($order as $storeOrdersOrderItem) {
            // validation for constraint: itemType
            if (!$storeOrdersOrderItem instanceof \cycro\StructType\ShipmentServiceData) {
                throw new \InvalidArgumentException(sprintf('The order property can only contain items of \cycro\StructType\ShipmentServiceData, "%s" given', is_object($storeOrdersOrderItem) ? get_class($storeOrdersOrderItem) : gettype($storeOrdersOrderItem)), __LINE__);
            }
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ShipmentServiceData $item
     * @return \cycro\StructType\StoreOrders
     */
    public function addToOrder(\cycro\StructType\ShipmentServiceData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\ShipmentServiceData) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of \cycro\StructType\ShipmentServiceData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Get printOptions value
     * @return \cycro\StructType\PrintOptions|null
     */
    public function getPrintOptions()
    {
        return $this->printOptions;
    }
    /**
     * Set printOptions value
     * @param \cycro\StructType\PrintOptions $printOptions
     * @return \cycro\StructType\StoreOrders
     */
    public function setPrintOptions(\cycro\StructType\PrintOptions $printOptions = null)
    {
        $this->printOptions = $printOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\StoreOrders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
