<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles shipment response data.
 * @subpackage Structs
 */
class ShipmentResponse extends AbstractStructBase
{
    /**
     * The identificationNumber
     * Meta informations extracted from the WSDL
     * - documentation: Serves as unique alphanumeric key of the shipment used by customer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificationNumber;
    /**
     * The mpsId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: The shipment number for consignment data.If ordertype is pickup information, the shipment number is an internal database id,which is necessary for technical support requests at DPD. | The shipment number for consignment data. The
     * shipment number is only accepted if the parcel label number is allocated by customer.It starts with one of "MPS", "EXP" or "B2C", the last eight ciphers are the date in format yyyyMMdd.
     * - length: 25
     * - maxLength: 25
     * @var string
     */
    public $mpsId;
    /**
     * The parcelInformation
     * Meta informations extracted from the WSDL
     * - documentation: Contains information about the single parcels.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cycro\StructType\ParcelInformationType[]
     */
    public $parcelInformation;
    /**
     * The faults
     * Meta informations extracted from the WSDL
     * - documentation: Contains information about errors during shipment order processing.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \cycro\StructType\FaultCodeType[]
     */
    public $faults;
    /**
     * Constructor method for shipmentResponse
     * @uses ShipmentResponse::setIdentificationNumber()
     * @uses ShipmentResponse::setMpsId()
     * @uses ShipmentResponse::setParcelInformation()
     * @uses ShipmentResponse::setFaults()
     * @param string $identificationNumber
     * @param string $mpsId
     * @param \cycro\StructType\ParcelInformationType[] $parcelInformation
     * @param \cycro\StructType\FaultCodeType[] $faults
     */
    public function __construct($identificationNumber = null, $mpsId = null, array $parcelInformation = array(), array $faults = array())
    {
        $this
            ->setIdentificationNumber($identificationNumber)
            ->setMpsId($mpsId)
            ->setParcelInformation($parcelInformation)
            ->setFaults($faults);
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \cycro\StructType\ShipmentResponse
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get mpsId value
     * @return string|null
     */
    public function getMpsId()
    {
        return $this->mpsId;
    }
    /**
     * Set mpsId value
     * @param string $mpsId
     * @return \cycro\StructType\ShipmentResponse
     */
    public function setMpsId($mpsId = null)
    {
        // validation for constraint: length
        if ((is_scalar($mpsId) && strlen($mpsId) !== 25) || (is_array($mpsId) && count($mpsId) !== 25)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s)', __LINE__);
        }
        // validation for constraint: maxLength
        if ((is_scalar($mpsId) && strlen($mpsId) > 25) || (is_array($mpsId) && count($mpsId) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($mpsId) ? strlen($mpsId) : count($mpsId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsId) && !is_string($mpsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsId)), __LINE__);
        }
        $this->mpsId = $mpsId;
        return $this;
    }
    /**
     * Get parcelInformation value
     * @return \cycro\StructType\ParcelInformationType[]|null
     */
    public function getParcelInformation()
    {
        return $this->parcelInformation;
    }
    /**
     * Set parcelInformation value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ParcelInformationType[] $parcelInformation
     * @return \cycro\StructType\ShipmentResponse
     */
    public function setParcelInformation(array $parcelInformation = array())
    {
        foreach ($parcelInformation as $shipmentResponseParcelInformationItem) {
            // validation for constraint: itemType
            if (!$shipmentResponseParcelInformationItem instanceof \cycro\StructType\ParcelInformationType) {
                throw new \InvalidArgumentException(sprintf('The parcelInformation property can only contain items of \cycro\StructType\ParcelInformationType, "%s" given', is_object($shipmentResponseParcelInformationItem) ? get_class($shipmentResponseParcelInformationItem) : gettype($shipmentResponseParcelInformationItem)), __LINE__);
            }
        }
        $this->parcelInformation = $parcelInformation;
        return $this;
    }
    /**
     * Add item to parcelInformation value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ParcelInformationType $item
     * @return \cycro\StructType\ShipmentResponse
     */
    public function addToParcelInformation(\cycro\StructType\ParcelInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\ParcelInformationType) {
            throw new \InvalidArgumentException(sprintf('The parcelInformation property can only contain items of \cycro\StructType\ParcelInformationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parcelInformation[] = $item;
        return $this;
    }
    /**
     * Get faults value
     * @return \cycro\StructType\FaultCodeType[]|null
     */
    public function getFaults()
    {
        return $this->faults;
    }
    /**
     * Set faults value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\FaultCodeType[] $faults
     * @return \cycro\StructType\ShipmentResponse
     */
    public function setFaults(array $faults = array())
    {
        foreach ($faults as $shipmentResponseFaultsItem) {
            // validation for constraint: itemType
            if (!$shipmentResponseFaultsItem instanceof \cycro\StructType\FaultCodeType) {
                throw new \InvalidArgumentException(sprintf('The faults property can only contain items of \cycro\StructType\FaultCodeType, "%s" given', is_object($shipmentResponseFaultsItem) ? get_class($shipmentResponseFaultsItem) : gettype($shipmentResponseFaultsItem)), __LINE__);
            }
        }
        $this->faults = $faults;
        return $this;
    }
    /**
     * Add item to faults value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\FaultCodeType $item
     * @return \cycro\StructType\ShipmentResponse
     */
    public function addToFaults(\cycro\StructType\FaultCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\FaultCodeType) {
            throw new \InvalidArgumentException(sprintf('The faults property can only contain items of \cycro\StructType\FaultCodeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->faults[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\ShipmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
