<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productAndServiceData StructType
 * @subpackage Structs
 */
class ProductAndServiceData extends AbstractStructBase
{
    /**
     * The orderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $orderType;
    /**
     * The saturdayDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Defines if saturday delivery is demanded. Only selectable for product "E12". Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $saturdayDelivery;
    /**
     * The exWorksDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the recipient has to pay the consignment. Default value is false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $exWorksDelivery;
    /**
     * The guarantee
     * Meta informations extracted from the WSDL
     * - documentation: Set to true if an international shipment shall use Guarantee, only for products NP and E18 in international parcels
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $guarantee;
    /**
     * The tyres
     * Meta informations extracted from the WSDL
     * - documentation: Set to true if this consignment contains bulk tyres, only for product NP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $tyres;
    /**
     * The personalDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Contains information for personal delivery.
     * - minOccurs: 0
     * @var \cycro\StructType\PersonalDelivery
     */
    public $personalDelivery;
    /**
     * The pickup
     * Meta informations extracted from the WSDL
     * - documentation: Contains information for pickup consignments, pickup address for collection requests or details for pickup information.
     * - minOccurs: 0
     * @var \cycro\StructType\Pickup
     */
    public $pickup;
    /**
     * The parcelShopDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Contains the necessary information, if a parcel shop delivery is intended.
     * - minOccurs: 0
     * @var \cycro\StructType\ParcelShopDelivery
     */
    public $parcelShopDelivery;
    /**
     * The predict
     * Meta informations extracted from the WSDL
     * - documentation: Contains data for interactive notification for consignments. Only channel e-mail and SMS is allowed.
     * - minOccurs: 0
     * @var \cycro\StructType\Notification
     */
    public $predict;
    /**
     * The personalDeliveryNotification
     * Meta informations extracted from the WSDL
     * - documentation: Contains data for personal delivery notification for consignments.
     * - minOccurs: 0
     * @var \cycro\StructType\Notification
     */
    public $personalDeliveryNotification;
    /**
     * The proactiveNotification
     * Meta informations extracted from the WSDL
     * - documentation: Contains information of proactive notification for consignments.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \cycro\StructType\ProactiveNotification[]
     */
    public $proactiveNotification;
    /**
     * The delivery
     * Meta informations extracted from the WSDL
     * - documentation: Contains special delivery data for consignments.
     * - minOccurs: 0
     * @var \cycro\StructType\Delivery
     */
    public $delivery;
    /**
     * The invoiceAddress
     * Meta informations extracted from the WSDL
     * - documentation: Contains data about invoice recipient if it differs for consignment.
     * - minOccurs: 0
     * @var \cycro\StructType\Address
     */
    public $invoiceAddress;
    /**
     * The countrySpecificService
     * Meta informations extracted from the WSDL
     * - documentation: In some relations a specific service code can be set which overwrites the feature selection.
     * - minOccurs: 0
     * @var string
     */
    public $countrySpecificService;
    /**
     * Constructor method for productAndServiceData
     * @uses ProductAndServiceData::setOrderType()
     * @uses ProductAndServiceData::setSaturdayDelivery()
     * @uses ProductAndServiceData::setExWorksDelivery()
     * @uses ProductAndServiceData::setGuarantee()
     * @uses ProductAndServiceData::setTyres()
     * @uses ProductAndServiceData::setPersonalDelivery()
     * @uses ProductAndServiceData::setPickup()
     * @uses ProductAndServiceData::setParcelShopDelivery()
     * @uses ProductAndServiceData::setPredict()
     * @uses ProductAndServiceData::setPersonalDeliveryNotification()
     * @uses ProductAndServiceData::setProactiveNotification()
     * @uses ProductAndServiceData::setDelivery()
     * @uses ProductAndServiceData::setInvoiceAddress()
     * @uses ProductAndServiceData::setCountrySpecificService()
     * @param string $orderType
     * @param bool $saturdayDelivery
     * @param bool $exWorksDelivery
     * @param bool $guarantee
     * @param bool $tyres
     * @param \cycro\StructType\PersonalDelivery $personalDelivery
     * @param \cycro\StructType\Pickup $pickup
     * @param \cycro\StructType\ParcelShopDelivery $parcelShopDelivery
     * @param \cycro\StructType\Notification $predict
     * @param \cycro\StructType\Notification $personalDeliveryNotification
     * @param \cycro\StructType\ProactiveNotification[] $proactiveNotification
     * @param \cycro\StructType\Delivery $delivery
     * @param \cycro\StructType\Address $invoiceAddress
     * @param string $countrySpecificService
     */
    public function __construct($orderType = null, $saturdayDelivery = null, $exWorksDelivery = null, $guarantee = null, $tyres = null, \cycro\StructType\PersonalDelivery $personalDelivery = null, \cycro\StructType\Pickup $pickup = null, \cycro\StructType\ParcelShopDelivery $parcelShopDelivery = null, \cycro\StructType\Notification $predict = null, \cycro\StructType\Notification $personalDeliveryNotification = null, array $proactiveNotification = array(), \cycro\StructType\Delivery $delivery = null, \cycro\StructType\Address $invoiceAddress = null, $countrySpecificService = null)
    {
        $this
            ->setOrderType($orderType)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setExWorksDelivery($exWorksDelivery)
            ->setGuarantee($guarantee)
            ->setTyres($tyres)
            ->setPersonalDelivery($personalDelivery)
            ->setPickup($pickup)
            ->setParcelShopDelivery($parcelShopDelivery)
            ->setPredict($predict)
            ->setPersonalDeliveryNotification($personalDeliveryNotification)
            ->setProactiveNotification($proactiveNotification)
            ->setDelivery($delivery)
            ->setInvoiceAddress($invoiceAddress)
            ->setCountrySpecificService($countrySpecificService);
    }
    /**
     * Get orderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @uses \cycro\EnumType\OrderType::valueIsValid()
     * @uses \cycro\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderType, implode(', ', \cycro\EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get saturdayDelivery value
     * @return bool|null
     */
    public function getSaturdayDelivery()
    {
        return $this->saturdayDelivery;
    }
    /**
     * Set saturdayDelivery value
     * @param bool $saturdayDelivery
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setSaturdayDelivery($saturdayDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayDelivery) && !is_bool($saturdayDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($saturdayDelivery)), __LINE__);
        }
        $this->saturdayDelivery = $saturdayDelivery;
        return $this;
    }
    /**
     * Get exWorksDelivery value
     * @return bool|null
     */
    public function getExWorksDelivery()
    {
        return $this->exWorksDelivery;
    }
    /**
     * Set exWorksDelivery value
     * @param bool $exWorksDelivery
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setExWorksDelivery($exWorksDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($exWorksDelivery) && !is_bool($exWorksDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exWorksDelivery)), __LINE__);
        }
        $this->exWorksDelivery = $exWorksDelivery;
        return $this;
    }
    /**
     * Get guarantee value
     * @return bool|null
     */
    public function getGuarantee()
    {
        return $this->guarantee;
    }
    /**
     * Set guarantee value
     * @param bool $guarantee
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setGuarantee($guarantee = null)
    {
        // validation for constraint: boolean
        if (!is_null($guarantee) && !is_bool($guarantee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guarantee)), __LINE__);
        }
        $this->guarantee = $guarantee;
        return $this;
    }
    /**
     * Get tyres value
     * @return bool|null
     */
    public function getTyres()
    {
        return $this->tyres;
    }
    /**
     * Set tyres value
     * @param bool $tyres
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setTyres($tyres = null)
    {
        // validation for constraint: boolean
        if (!is_null($tyres) && !is_bool($tyres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tyres)), __LINE__);
        }
        $this->tyres = $tyres;
        return $this;
    }
    /**
     * Get personalDelivery value
     * @return \cycro\StructType\PersonalDelivery|null
     */
    public function getPersonalDelivery()
    {
        return $this->personalDelivery;
    }
    /**
     * Set personalDelivery value
     * @param \cycro\StructType\PersonalDelivery $personalDelivery
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setPersonalDelivery(\cycro\StructType\PersonalDelivery $personalDelivery = null)
    {
        $this->personalDelivery = $personalDelivery;
        return $this;
    }
    /**
     * Get pickup value
     * @return \cycro\StructType\Pickup|null
     */
    public function getPickup()
    {
        return $this->pickup;
    }
    /**
     * Set pickup value
     * @param \cycro\StructType\Pickup $pickup
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setPickup(\cycro\StructType\Pickup $pickup = null)
    {
        $this->pickup = $pickup;
        return $this;
    }
    /**
     * Get parcelShopDelivery value
     * @return \cycro\StructType\ParcelShopDelivery|null
     */
    public function getParcelShopDelivery()
    {
        return $this->parcelShopDelivery;
    }
    /**
     * Set parcelShopDelivery value
     * @param \cycro\StructType\ParcelShopDelivery $parcelShopDelivery
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setParcelShopDelivery(\cycro\StructType\ParcelShopDelivery $parcelShopDelivery = null)
    {
        $this->parcelShopDelivery = $parcelShopDelivery;
        return $this;
    }
    /**
     * Get predict value
     * @return \cycro\StructType\Notification|null
     */
    public function getPredict()
    {
        return $this->predict;
    }
    /**
     * Set predict value
     * @param \cycro\StructType\Notification $predict
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setPredict(\cycro\StructType\Notification $predict = null)
    {
        $this->predict = $predict;
        return $this;
    }
    /**
     * Get personalDeliveryNotification value
     * @return \cycro\StructType\Notification|null
     */
    public function getPersonalDeliveryNotification()
    {
        return $this->personalDeliveryNotification;
    }
    /**
     * Set personalDeliveryNotification value
     * @param \cycro\StructType\Notification $personalDeliveryNotification
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setPersonalDeliveryNotification(\cycro\StructType\Notification $personalDeliveryNotification = null)
    {
        $this->personalDeliveryNotification = $personalDeliveryNotification;
        return $this;
    }
    /**
     * Get proactiveNotification value
     * @return \cycro\StructType\ProactiveNotification[]|null
     */
    public function getProactiveNotification()
    {
        return $this->proactiveNotification;
    }
    /**
     * Set proactiveNotification value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ProactiveNotification[] $proactiveNotification
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setProactiveNotification(array $proactiveNotification = array())
    {
        foreach ($proactiveNotification as $productAndServiceDataProactiveNotificationItem) {
            // validation for constraint: itemType
            if (!$productAndServiceDataProactiveNotificationItem instanceof \cycro\StructType\ProactiveNotification) {
                throw new \InvalidArgumentException(sprintf('The proactiveNotification property can only contain items of \cycro\StructType\ProactiveNotification, "%s" given', is_object($productAndServiceDataProactiveNotificationItem) ? get_class($productAndServiceDataProactiveNotificationItem) : gettype($productAndServiceDataProactiveNotificationItem)), __LINE__);
            }
        }
        $this->proactiveNotification = $proactiveNotification;
        return $this;
    }
    /**
     * Add item to proactiveNotification value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ProactiveNotification $item
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function addToProactiveNotification(\cycro\StructType\ProactiveNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\ProactiveNotification) {
            throw new \InvalidArgumentException(sprintf('The proactiveNotification property can only contain items of \cycro\StructType\ProactiveNotification, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->proactiveNotification[] = $item;
        return $this;
    }
    /**
     * Get delivery value
     * @return \cycro\StructType\Delivery|null
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @param \cycro\StructType\Delivery $delivery
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setDelivery(\cycro\StructType\Delivery $delivery = null)
    {
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Get invoiceAddress value
     * @return \cycro\StructType\Address|null
     */
    public function getInvoiceAddress()
    {
        return $this->invoiceAddress;
    }
    /**
     * Set invoiceAddress value
     * @param \cycro\StructType\Address $invoiceAddress
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setInvoiceAddress(\cycro\StructType\Address $invoiceAddress = null)
    {
        $this->invoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get countrySpecificService value
     * @return string|null
     */
    public function getCountrySpecificService()
    {
        return $this->countrySpecificService;
    }
    /**
     * Set countrySpecificService value
     * @param string $countrySpecificService
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function setCountrySpecificService($countrySpecificService = null)
    {
        // validation for constraint: string
        if (!is_null($countrySpecificService) && !is_string($countrySpecificService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countrySpecificService)), __LINE__);
        }
        $this->countrySpecificService = $countrySpecificService;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\ProductAndServiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
