<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about the printer, if direct printing is selected.
 * @subpackage Structs
 */
class Printer extends AbstractStructBase
{
    /**
     * The offsetX
     * Meta informations extracted from the WSDL
     * - documentation: The horizontal offset in mm for the direct printer file (Not used with normal PDF output).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $offsetX;
    /**
     * The offsetY
     * Meta informations extracted from the WSDL
     * - documentation: The vertical offset in mm for the direct printer file (Not used with normal PDF output).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $offsetY;
    /**
     * The connectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $connectionType;
    /**
     * The barcodeCapable2D
     * Meta informations extracted from the WSDL
     * - documentation: If the printer can print AZTEC barcodes, set this flag to true.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $barcodeCapable2D;
    /**
     * The manufacturer
     * Meta informations extracted from the WSDL
     * - documentation: The printer's manufacturer. At the moment only for informational purposes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manufacturer;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: The printer's model. At the moment only for informational purposes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The revision
     * Meta informations extracted from the WSDL
     * - documentation: The printer's revision / version. At the moment only for informational purposes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $revision;
    /**
     * Constructor method for printer
     * @uses Printer::setOffsetX()
     * @uses Printer::setOffsetY()
     * @uses Printer::setConnectionType()
     * @uses Printer::setBarcodeCapable2D()
     * @uses Printer::setManufacturer()
     * @uses Printer::setModel()
     * @uses Printer::setRevision()
     * @param float $offsetX
     * @param float $offsetY
     * @param string $connectionType
     * @param bool $barcodeCapable2D
     * @param string $manufacturer
     * @param string $model
     * @param string $revision
     */
    public function __construct($offsetX = null, $offsetY = null, $connectionType = null, $barcodeCapable2D = null, $manufacturer = null, $model = null, $revision = null)
    {
        $this
            ->setOffsetX($offsetX)
            ->setOffsetY($offsetY)
            ->setConnectionType($connectionType)
            ->setBarcodeCapable2D($barcodeCapable2D)
            ->setManufacturer($manufacturer)
            ->setModel($model)
            ->setRevision($revision);
    }
    /**
     * Get offsetX value
     * @return float
     */
    public function getOffsetX()
    {
        return $this->offsetX;
    }
    /**
     * Set offsetX value
     * @param float $offsetX
     * @return \cycro\StructType\Printer
     */
    public function setOffsetX($offsetX = null)
    {
        $this->offsetX = $offsetX;
        return $this;
    }
    /**
     * Get offsetY value
     * @return float
     */
    public function getOffsetY()
    {
        return $this->offsetY;
    }
    /**
     * Set offsetY value
     * @param float $offsetY
     * @return \cycro\StructType\Printer
     */
    public function setOffsetY($offsetY = null)
    {
        $this->offsetY = $offsetY;
        return $this;
    }
    /**
     * Get connectionType value
     * @return string
     */
    public function getConnectionType()
    {
        return $this->connectionType;
    }
    /**
     * Set connectionType value
     * @uses \cycro\EnumType\ConnectionType::valueIsValid()
     * @uses \cycro\EnumType\ConnectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionType
     * @return \cycro\StructType\Printer
     */
    public function setConnectionType($connectionType = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\ConnectionType::valueIsValid($connectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectionType, implode(', ', \cycro\EnumType\ConnectionType::getValidValues())), __LINE__);
        }
        $this->connectionType = $connectionType;
        return $this;
    }
    /**
     * Get barcodeCapable2D value
     * @return bool
     */
    public function getBarcodeCapable2D()
    {
        return $this->barcodeCapable2D;
    }
    /**
     * Set barcodeCapable2D value
     * @param bool $barcodeCapable2D
     * @return \cycro\StructType\Printer
     */
    public function setBarcodeCapable2D($barcodeCapable2D = null)
    {
        // validation for constraint: boolean
        if (!is_null($barcodeCapable2D) && !is_bool($barcodeCapable2D)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($barcodeCapable2D)), __LINE__);
        }
        $this->barcodeCapable2D = $barcodeCapable2D;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \cycro\StructType\Printer
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \cycro\StructType\Printer
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get revision value
     * @return string|null
     */
    public function getRevision()
    {
        return $this->revision;
    }
    /**
     * Set revision value
     * @param string $revision
     * @return \cycro\StructType\Printer
     */
    public function setRevision($revision = null)
    {
        // validation for constraint: string
        if (!is_null($revision) && !is_string($revision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($revision)), __LINE__);
        }
        $this->revision = $revision;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Printer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
