<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printOptions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Options how to return the parcel labels
 * @subpackage Structs
 */
class PrintOptions extends AbstractStructBase
{
    /**
     * The printerLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $printerLanguage;
    /**
     * The paperFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paperFormat;
    /**
     * The printer
     * Meta informations extracted from the WSDL
     * - documentation: Information about the printer. Enabled if direct printing is selected.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \cycro\StructType\Printer
     */
    public $printer;
    /**
     * The startPosition
     * Meta informations extracted from the WSDL
     * - documentation: Start position for print on A4 paper.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startPosition;
    /**
     * Constructor method for printOptions
     * @uses PrintOptions::setPrinterLanguage()
     * @uses PrintOptions::setPaperFormat()
     * @uses PrintOptions::setPrinter()
     * @uses PrintOptions::setStartPosition()
     * @param string $printerLanguage
     * @param string $paperFormat
     * @param \cycro\StructType\Printer $printer
     * @param string $startPosition
     */
    public function __construct($printerLanguage = null, $paperFormat = null, \cycro\StructType\Printer $printer = null, $startPosition = null)
    {
        $this
            ->setPrinterLanguage($printerLanguage)
            ->setPaperFormat($paperFormat)
            ->setPrinter($printer)
            ->setStartPosition($startPosition);
    }
    /**
     * Get printerLanguage value
     * @return string
     */
    public function getPrinterLanguage()
    {
        return $this->printerLanguage;
    }
    /**
     * Set printerLanguage value
     * @uses \cycro\EnumType\PrinterLanguage::valueIsValid()
     * @uses \cycro\EnumType\PrinterLanguage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printerLanguage
     * @return \cycro\StructType\PrintOptions
     */
    public function setPrinterLanguage($printerLanguage = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\PrinterLanguage::valueIsValid($printerLanguage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $printerLanguage, implode(', ', \cycro\EnumType\PrinterLanguage::getValidValues())), __LINE__);
        }
        $this->printerLanguage = $printerLanguage;
        return $this;
    }
    /**
     * Get paperFormat value
     * @return string
     */
    public function getPaperFormat()
    {
        return $this->paperFormat;
    }
    /**
     * Set paperFormat value
     * @uses \cycro\EnumType\PaperFormat::valueIsValid()
     * @uses \cycro\EnumType\PaperFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paperFormat
     * @return \cycro\StructType\PrintOptions
     */
    public function setPaperFormat($paperFormat = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\PaperFormat::valueIsValid($paperFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paperFormat, implode(', ', \cycro\EnumType\PaperFormat::getValidValues())), __LINE__);
        }
        $this->paperFormat = $paperFormat;
        return $this;
    }
    /**
     * Get printer value
     * @return \cycro\StructType\Printer|null
     */
    public function getPrinter()
    {
        return $this->printer;
    }
    /**
     * Set printer value
     * @param \cycro\StructType\Printer $printer
     * @return \cycro\StructType\PrintOptions
     */
    public function setPrinter(\cycro\StructType\Printer $printer = null)
    {
        $this->printer = $printer;
        return $this;
    }
    /**
     * Get startPosition value
     * @return string|null
     */
    public function getStartPosition()
    {
        return $this->startPosition;
    }
    /**
     * Set startPosition value
     * @uses \cycro\EnumType\StartPosition::valueIsValid()
     * @uses \cycro\EnumType\StartPosition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startPosition
     * @return \cycro\StructType\PrintOptions
     */
    public function setStartPosition($startPosition = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\StartPosition::valueIsValid($startPosition)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startPosition, implode(', ', \cycro\EnumType\StartPosition::getValidValues())), __LINE__);
        }
        $this->startPosition = $startPosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\PrintOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
