<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personalDelivery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles personal delivery data.
 * @subpackage Structs
 */
class PersonalDelivery extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Defines type of personal delivery. Possible values are:1 = department delivery (without personal identification)2 = personal delivery with personal identification (ID-Check)3 = personal delivery without personal identification at
     * drop point (e.g. parcel shop)4 = personal delivery with personal identification at drop point (e.g. parcel shop)5 = personal delivery with personal identification at drop point plus ID-Check (e.g. parcel shop)For parcel shop delivery the parcel shop
     * id must be declared in productAndServiceData. It can be obtained from parcel shop finder.
     * - maxInclusive: 5
     * - minInclusive: 1
     * @var int
     */
    public $type;
    /**
     * The floor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Floor where the personal delivery shall take place. This field is only used for department delivery.
     * - maxLength: 30
     * @var string
     */
    public $floor;
    /**
     * The building
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Building where the personal delivery shall take place. This field is only used for department delivery (type 1).
     * - maxLength: 30
     * @var string
     */
    public $building;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Department where the personal delivery shall take place. This field is only used for department delivery (type 1).
     * - maxLength: 30
     * @var string
     */
    public $department;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Name of the person authorised to accept the consignment. This field is only used for delivery with ID-Check (types 2 and 4).
     * - maxLength: 35
     * @var string
     */
    public $name;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Phone number of address owner. Mandatory if phone is the chosen notification channel. No required data format. | Telephone number of the person authorised to accept the consignment. This field is only used for delivery with ID-Check
     * (types 2 and 4). No required data format.
     * - maxLength: 20
     * @var string
     */
    public $phone;
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Personal identification number of the person authorised to accept the consignment. This field is only used for delivery with ID-Check (types 2 and 4).
     * - maxLength: 35
     * @var string
     */
    public $personId;
    /**
     * Constructor method for personalDelivery
     * @uses PersonalDelivery::setType()
     * @uses PersonalDelivery::setFloor()
     * @uses PersonalDelivery::setBuilding()
     * @uses PersonalDelivery::setDepartment()
     * @uses PersonalDelivery::setName()
     * @uses PersonalDelivery::setPhone()
     * @uses PersonalDelivery::setPersonId()
     * @param int $type
     * @param string $floor
     * @param string $building
     * @param string $department
     * @param string $name
     * @param string $phone
     * @param string $personId
     */
    public function __construct($type = null, $floor = null, $building = null, $department = null, $name = null, $phone = null, $personId = null)
    {
        $this
            ->setType($type)
            ->setFloor($floor)
            ->setBuilding($building)
            ->setDepartment($department)
            ->setName($name)
            ->setPhone($phone)
            ->setPersonId($personId);
    }
    /**
     * Get type value
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setType($type = null)
    {
        // validation for constraint: maxInclusive
        if ($type > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 5, "%s" given', $type), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($type < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $type), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($floor) && strlen($floor) > 30) || (is_array($floor) && count($floor) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($floor) ? strlen($floor) : count($floor)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($building) && strlen($building) > 30) || (is_array($building) && count($building) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($building) ? strlen($building) : count($building)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($department) && strlen($department) > 30) || (is_array($department) && count($department) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($department) ? strlen($department) : count($department)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 35) || (is_array($name) && count($name) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phone) && strlen($phone) > 20) || (is_array($phone) && count($phone) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($phone) ? strlen($phone) : count($phone)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get personId value
     * @return string|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param string $personId
     * @return \cycro\StructType\PersonalDelivery
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($personId) && strlen($personId) > 35) || (is_array($personId) && count($personId) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($personId) ? strlen($personId) : count($personId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\PersonalDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
