<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelInformationType StructType
 * @subpackage Structs
 */
class ParcelInformationType extends AbstractStructBase
{
    /**
     * The parcelLabelNumber
     * Meta informations extracted from the WSDL
     * - documentation: The parcel label number of the corresponding parcel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelLabelNumber;
    /**
     * The dpdReference
     * Meta informations extracted from the WSDL
     * - documentation: The DPD reference for this parcel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dpdReference;
    /**
     * Constructor method for parcelInformationType
     * @uses ParcelInformationType::setParcelLabelNumber()
     * @uses ParcelInformationType::setDpdReference()
     * @param string $parcelLabelNumber
     * @param string $dpdReference
     */
    public function __construct($parcelLabelNumber = null, $dpdReference = null)
    {
        $this
            ->setParcelLabelNumber($parcelLabelNumber)
            ->setDpdReference($dpdReference);
    }
    /**
     * Get parcelLabelNumber value
     * @return string|null
     */
    public function getParcelLabelNumber()
    {
        return $this->parcelLabelNumber;
    }
    /**
     * Set parcelLabelNumber value
     * @param string $parcelLabelNumber
     * @return \cycro\StructType\ParcelInformationType
     */
    public function setParcelLabelNumber($parcelLabelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelLabelNumber) && !is_string($parcelLabelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelLabelNumber)), __LINE__);
        }
        $this->parcelLabelNumber = $parcelLabelNumber;
        return $this;
    }
    /**
     * Get dpdReference value
     * @return string|null
     */
    public function getDpdReference()
    {
        return $this->dpdReference;
    }
    /**
     * Set dpdReference value
     * @param string $dpdReference
     * @return \cycro\StructType\ParcelInformationType
     */
    public function setDpdReference($dpdReference = null)
    {
        // validation for constraint: string
        if (!is_null($dpdReference) && !is_string($dpdReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dpdReference)), __LINE__);
        }
        $this->dpdReference = $dpdReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\ParcelInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
