<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for international StructType
 * @subpackage Structs
 */
class International extends AbstractStructBase
{
    /**
     * The parcelType
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the type of parcel is "documents" (allowed for air based destination only). Default value is false.
     * - minOccurs: 1
     * @var bool
     */
    public $parcelType;
    /**
     * The customsAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Defines the customs amount in total without decimal separator (e.g. 14.00 = 1400). For documents it is 0.
     * - maxInclusive: 999999999999
     * @var int
     */
    public $customsAmount;
    /**
     * The customsCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Currency code in ISO 4217 alpha-3 format.
     * - length: 3
     * @var string
     */
    public $customsCurrency;
    /**
     * The customsTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $customsTerms;
    /**
     * The customsContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Describes the content of the parcel.
     * - maxLength: 35
     * @var string
     */
    public $customsContent;
    /**
     * The customsTarif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines the customs tarif number.
     * - maxLength: 8
     * @var string
     */
    public $customsTarif;
    /**
     * The customsPaper
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Lists the accompanying documents. The values are to be combined without separator (e.g. "ABG"). Following values are defined:A = commercial invoiceB = pro forma invoiceC = export declarationD = EUR1E = EUR2F = ATRG = delivery noteH =
     * third party billingI = T1 document
     * - maxLength: 20
     * @var string
     */
    public $customsPaper;
    /**
     * The customsEnclosure
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the accompanying documents are at the parcel or not. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $customsEnclosure;
    /**
     * The customsInvoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines the invoice number.
     * - maxLength: 20
     * @var string
     */
    public $customsInvoice;
    /**
     * The customsInvoiceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines the invoice date (format YYYYMMDD).
     * - maxInclusive: 99999999
     * @var int
     */
    public $customsInvoiceDate;
    /**
     * The customsAmountParcel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel value with two decimal places without separator.
     * - maxInclusive: 999999999999
     * @var int
     */
    public $customsAmountParcel;
    /**
     * The customsOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Origin country in ISO 3166-1 alpha-2 format (e.g. 'DE').
     * - length: 2
     * @var string
     */
    public $customsOrigin;
    /**
     * The linehaul
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linehaul;
    /**
     * The shipMrn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Movement reference number of the electronical export declaration.
     * - maxLength: 20
     * @var string
     */
    public $shipMrn;
    /**
     * The collectiveCustomsClearance
     * Meta informations extracted from the WSDL
     * - documentation: Flag for determining collective customs clearance. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $collectiveCustomsClearance;
    /**
     * The invoicePosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines the invoice position.
     * - maxLength: 6
     * @var string
     */
    public $invoicePosition;
    /**
     * The comment1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Comment.
     * - maxLength: 70
     * @var string
     */
    public $comment1;
    /**
     * The comment2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Second comment.
     * - maxLength: 70
     * @var string
     */
    public $comment2;
    /**
     * The commercialInvoiceConsigneeVatNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines the commercial invoice consignee VAT number.
     * - maxLength: 20
     * @var string
     */
    public $commercialInvoiceConsigneeVatNumber;
    /**
     * The commercialInvoiceConsignee
     * Meta informations extracted from the WSDL
     * - documentation: Contains address data of commercial invoice consignee.
     * @var \cycro\StructType\Address
     */
    public $commercialInvoiceConsignee;
    /**
     * Constructor method for international
     * @uses International::setParcelType()
     * @uses International::setCustomsAmount()
     * @uses International::setCustomsCurrency()
     * @uses International::setCustomsTerms()
     * @uses International::setCustomsContent()
     * @uses International::setCustomsTarif()
     * @uses International::setCustomsPaper()
     * @uses International::setCustomsEnclosure()
     * @uses International::setCustomsInvoice()
     * @uses International::setCustomsInvoiceDate()
     * @uses International::setCustomsAmountParcel()
     * @uses International::setCustomsOrigin()
     * @uses International::setLinehaul()
     * @uses International::setShipMrn()
     * @uses International::setCollectiveCustomsClearance()
     * @uses International::setInvoicePosition()
     * @uses International::setComment1()
     * @uses International::setComment2()
     * @uses International::setCommercialInvoiceConsigneeVatNumber()
     * @uses International::setCommercialInvoiceConsignee()
     * @param bool $parcelType
     * @param int $customsAmount
     * @param string $customsCurrency
     * @param string $customsTerms
     * @param string $customsContent
     * @param string $customsTarif
     * @param string $customsPaper
     * @param bool $customsEnclosure
     * @param string $customsInvoice
     * @param int $customsInvoiceDate
     * @param int $customsAmountParcel
     * @param string $customsOrigin
     * @param string $linehaul
     * @param string $shipMrn
     * @param bool $collectiveCustomsClearance
     * @param string $invoicePosition
     * @param string $comment1
     * @param string $comment2
     * @param string $commercialInvoiceConsigneeVatNumber
     * @param \cycro\StructType\Address $commercialInvoiceConsignee
     */
    public function __construct($parcelType = null, $customsAmount = null, $customsCurrency = null, $customsTerms = null, $customsContent = null, $customsTarif = null, $customsPaper = null, $customsEnclosure = null, $customsInvoice = null, $customsInvoiceDate = null, $customsAmountParcel = null, $customsOrigin = null, $linehaul = null, $shipMrn = null, $collectiveCustomsClearance = null, $invoicePosition = null, $comment1 = null, $comment2 = null, $commercialInvoiceConsigneeVatNumber = null, \cycro\StructType\Address $commercialInvoiceConsignee = null)
    {
        $this
            ->setParcelType($parcelType)
            ->setCustomsAmount($customsAmount)
            ->setCustomsCurrency($customsCurrency)
            ->setCustomsTerms($customsTerms)
            ->setCustomsContent($customsContent)
            ->setCustomsTarif($customsTarif)
            ->setCustomsPaper($customsPaper)
            ->setCustomsEnclosure($customsEnclosure)
            ->setCustomsInvoice($customsInvoice)
            ->setCustomsInvoiceDate($customsInvoiceDate)
            ->setCustomsAmountParcel($customsAmountParcel)
            ->setCustomsOrigin($customsOrigin)
            ->setLinehaul($linehaul)
            ->setShipMrn($shipMrn)
            ->setCollectiveCustomsClearance($collectiveCustomsClearance)
            ->setInvoicePosition($invoicePosition)
            ->setComment1($comment1)
            ->setComment2($comment2)
            ->setCommercialInvoiceConsigneeVatNumber($commercialInvoiceConsigneeVatNumber)
            ->setCommercialInvoiceConsignee($commercialInvoiceConsignee);
    }
    /**
     * Get parcelType value
     * @return bool
     */
    public function getParcelType()
    {
        return $this->parcelType;
    }
    /**
     * Set parcelType value
     * @param bool $parcelType
     * @return \cycro\StructType\International
     */
    public function setParcelType($parcelType = null)
    {
        // validation for constraint: boolean
        if (!is_null($parcelType) && !is_bool($parcelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($parcelType)), __LINE__);
        }
        $this->parcelType = $parcelType;
        return $this;
    }
    /**
     * Get customsAmount value
     * @return int
     */
    public function getCustomsAmount()
    {
        return $this->customsAmount;
    }
    /**
     * Set customsAmount value
     * @param int $customsAmount
     * @return \cycro\StructType\International
     */
    public function setCustomsAmount($customsAmount = null)
    {
        // validation for constraint: maxInclusive
        if ($customsAmount > 999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999, "%s" given', $customsAmount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($customsAmount) && !is_numeric($customsAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customsAmount)), __LINE__);
        }
        $this->customsAmount = $customsAmount;
        return $this;
    }
    /**
     * Get customsCurrency value
     * @return string
     */
    public function getCustomsCurrency()
    {
        return $this->customsCurrency;
    }
    /**
     * Set customsCurrency value
     * @param string $customsCurrency
     * @return \cycro\StructType\International
     */
    public function setCustomsCurrency($customsCurrency = null)
    {
        // validation for constraint: length
        if ((is_scalar($customsCurrency) && strlen($customsCurrency) !== 3) || (is_array($customsCurrency) && count($customsCurrency) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customsCurrency) && !is_string($customsCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customsCurrency)), __LINE__);
        }
        $this->customsCurrency = $customsCurrency;
        return $this;
    }
    /**
     * Get customsTerms value
     * @return string
     */
    public function getCustomsTerms()
    {
        return $this->customsTerms;
    }
    /**
     * Set customsTerms value
     * @uses \cycro\EnumType\CustomsTerms::valueIsValid()
     * @uses \cycro\EnumType\CustomsTerms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customsTerms
     * @return \cycro\StructType\International
     */
    public function setCustomsTerms($customsTerms = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\CustomsTerms::valueIsValid($customsTerms)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $customsTerms, implode(', ', \cycro\EnumType\CustomsTerms::getValidValues())), __LINE__);
        }
        $this->customsTerms = $customsTerms;
        return $this;
    }
    /**
     * Get customsContent value
     * @return string
     */
    public function getCustomsContent()
    {
        return $this->customsContent;
    }
    /**
     * Set customsContent value
     * @param string $customsContent
     * @return \cycro\StructType\International
     */
    public function setCustomsContent($customsContent = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customsContent) && strlen($customsContent) > 35) || (is_array($customsContent) && count($customsContent) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($customsContent) ? strlen($customsContent) : count($customsContent)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customsContent) && !is_string($customsContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customsContent)), __LINE__);
        }
        $this->customsContent = $customsContent;
        return $this;
    }
    /**
     * Get customsTarif value
     * @return string|null
     */
    public function getCustomsTarif()
    {
        return $this->customsTarif;
    }
    /**
     * Set customsTarif value
     * @param string $customsTarif
     * @return \cycro\StructType\International
     */
    public function setCustomsTarif($customsTarif = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customsTarif) && strlen($customsTarif) > 8) || (is_array($customsTarif) && count($customsTarif) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($customsTarif) ? strlen($customsTarif) : count($customsTarif)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customsTarif) && !is_string($customsTarif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customsTarif)), __LINE__);
        }
        $this->customsTarif = $customsTarif;
        return $this;
    }
    /**
     * Get customsPaper value
     * @return string|null
     */
    public function getCustomsPaper()
    {
        return $this->customsPaper;
    }
    /**
     * Set customsPaper value
     * @param string $customsPaper
     * @return \cycro\StructType\International
     */
    public function setCustomsPaper($customsPaper = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customsPaper) && strlen($customsPaper) > 20) || (is_array($customsPaper) && count($customsPaper) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($customsPaper) ? strlen($customsPaper) : count($customsPaper)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customsPaper) && !is_string($customsPaper)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customsPaper)), __LINE__);
        }
        $this->customsPaper = $customsPaper;
        return $this;
    }
    /**
     * Get customsEnclosure value
     * @return bool|null
     */
    public function getCustomsEnclosure()
    {
        return $this->customsEnclosure;
    }
    /**
     * Set customsEnclosure value
     * @param bool $customsEnclosure
     * @return \cycro\StructType\International
     */
    public function setCustomsEnclosure($customsEnclosure = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsEnclosure) && !is_bool($customsEnclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($customsEnclosure)), __LINE__);
        }
        $this->customsEnclosure = $customsEnclosure;
        return $this;
    }
    /**
     * Get customsInvoice value
     * @return string|null
     */
    public function getCustomsInvoice()
    {
        return $this->customsInvoice;
    }
    /**
     * Set customsInvoice value
     * @param string $customsInvoice
     * @return \cycro\StructType\International
     */
    public function setCustomsInvoice($customsInvoice = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customsInvoice) && strlen($customsInvoice) > 20) || (is_array($customsInvoice) && count($customsInvoice) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($customsInvoice) ? strlen($customsInvoice) : count($customsInvoice)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customsInvoice) && !is_string($customsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customsInvoice)), __LINE__);
        }
        $this->customsInvoice = $customsInvoice;
        return $this;
    }
    /**
     * Get customsInvoiceDate value
     * @return int|null
     */
    public function getCustomsInvoiceDate()
    {
        return $this->customsInvoiceDate;
    }
    /**
     * Set customsInvoiceDate value
     * @param int $customsInvoiceDate
     * @return \cycro\StructType\International
     */
    public function setCustomsInvoiceDate($customsInvoiceDate = null)
    {
        // validation for constraint: maxInclusive
        if ($customsInvoiceDate > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999, "%s" given', $customsInvoiceDate), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($customsInvoiceDate) && !is_numeric($customsInvoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customsInvoiceDate)), __LINE__);
        }
        $this->customsInvoiceDate = $customsInvoiceDate;
        return $this;
    }
    /**
     * Get customsAmountParcel value
     * @return int|null
     */
    public function getCustomsAmountParcel()
    {
        return $this->customsAmountParcel;
    }
    /**
     * Set customsAmountParcel value
     * @param int $customsAmountParcel
     * @return \cycro\StructType\International
     */
    public function setCustomsAmountParcel($customsAmountParcel = null)
    {
        // validation for constraint: maxInclusive
        if ($customsAmountParcel > 999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999, "%s" given', $customsAmountParcel), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($customsAmountParcel) && !is_numeric($customsAmountParcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customsAmountParcel)), __LINE__);
        }
        $this->customsAmountParcel = $customsAmountParcel;
        return $this;
    }
    /**
     * Get customsOrigin value
     * @return string|null
     */
    public function getCustomsOrigin()
    {
        return $this->customsOrigin;
    }
    /**
     * Set customsOrigin value
     * @param string $customsOrigin
     * @return \cycro\StructType\International
     */
    public function setCustomsOrigin($customsOrigin = null)
    {
        // validation for constraint: length
        if ((is_scalar($customsOrigin) && strlen($customsOrigin) !== 2) || (is_array($customsOrigin) && count($customsOrigin) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customsOrigin) && !is_string($customsOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customsOrigin)), __LINE__);
        }
        $this->customsOrigin = $customsOrigin;
        return $this;
    }
    /**
     * Get linehaul value
     * @return string|null
     */
    public function getLinehaul()
    {
        return $this->linehaul;
    }
    /**
     * Set linehaul value
     * @uses \cycro\EnumType\Linehaul::valueIsValid()
     * @uses \cycro\EnumType\Linehaul::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $linehaul
     * @return \cycro\StructType\International
     */
    public function setLinehaul($linehaul = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\Linehaul::valueIsValid($linehaul)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $linehaul, implode(', ', \cycro\EnumType\Linehaul::getValidValues())), __LINE__);
        }
        $this->linehaul = $linehaul;
        return $this;
    }
    /**
     * Get shipMrn value
     * @return string|null
     */
    public function getShipMrn()
    {
        return $this->shipMrn;
    }
    /**
     * Set shipMrn value
     * @param string $shipMrn
     * @return \cycro\StructType\International
     */
    public function setShipMrn($shipMrn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shipMrn) && strlen($shipMrn) > 20) || (is_array($shipMrn) && count($shipMrn) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($shipMrn) ? strlen($shipMrn) : count($shipMrn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shipMrn) && !is_string($shipMrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipMrn)), __LINE__);
        }
        $this->shipMrn = $shipMrn;
        return $this;
    }
    /**
     * Get collectiveCustomsClearance value
     * @return bool|null
     */
    public function getCollectiveCustomsClearance()
    {
        return $this->collectiveCustomsClearance;
    }
    /**
     * Set collectiveCustomsClearance value
     * @param bool $collectiveCustomsClearance
     * @return \cycro\StructType\International
     */
    public function setCollectiveCustomsClearance($collectiveCustomsClearance = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectiveCustomsClearance) && !is_bool($collectiveCustomsClearance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($collectiveCustomsClearance)), __LINE__);
        }
        $this->collectiveCustomsClearance = $collectiveCustomsClearance;
        return $this;
    }
    /**
     * Get invoicePosition value
     * @return string|null
     */
    public function getInvoicePosition()
    {
        return $this->invoicePosition;
    }
    /**
     * Set invoicePosition value
     * @param string $invoicePosition
     * @return \cycro\StructType\International
     */
    public function setInvoicePosition($invoicePosition = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoicePosition) && strlen($invoicePosition) > 6) || (is_array($invoicePosition) && count($invoicePosition) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($invoicePosition) ? strlen($invoicePosition) : count($invoicePosition)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoicePosition) && !is_string($invoicePosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoicePosition)), __LINE__);
        }
        $this->invoicePosition = $invoicePosition;
        return $this;
    }
    /**
     * Get comment1 value
     * @return string|null
     */
    public function getComment1()
    {
        return $this->comment1;
    }
    /**
     * Set comment1 value
     * @param string $comment1
     * @return \cycro\StructType\International
     */
    public function setComment1($comment1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($comment1) && strlen($comment1) > 70) || (is_array($comment1) && count($comment1) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($comment1) ? strlen($comment1) : count($comment1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($comment1) && !is_string($comment1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment1)), __LINE__);
        }
        $this->comment1 = $comment1;
        return $this;
    }
    /**
     * Get comment2 value
     * @return string|null
     */
    public function getComment2()
    {
        return $this->comment2;
    }
    /**
     * Set comment2 value
     * @param string $comment2
     * @return \cycro\StructType\International
     */
    public function setComment2($comment2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($comment2) && strlen($comment2) > 70) || (is_array($comment2) && count($comment2) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($comment2) ? strlen($comment2) : count($comment2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($comment2) && !is_string($comment2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment2)), __LINE__);
        }
        $this->comment2 = $comment2;
        return $this;
    }
    /**
     * Get commercialInvoiceConsigneeVatNumber value
     * @return string|null
     */
    public function getCommercialInvoiceConsigneeVatNumber()
    {
        return $this->commercialInvoiceConsigneeVatNumber;
    }
    /**
     * Set commercialInvoiceConsigneeVatNumber value
     * @param string $commercialInvoiceConsigneeVatNumber
     * @return \cycro\StructType\International
     */
    public function setCommercialInvoiceConsigneeVatNumber($commercialInvoiceConsigneeVatNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($commercialInvoiceConsigneeVatNumber) && strlen($commercialInvoiceConsigneeVatNumber) > 20) || (is_array($commercialInvoiceConsigneeVatNumber) && count($commercialInvoiceConsigneeVatNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($commercialInvoiceConsigneeVatNumber) ? strlen($commercialInvoiceConsigneeVatNumber) : count($commercialInvoiceConsigneeVatNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($commercialInvoiceConsigneeVatNumber) && !is_string($commercialInvoiceConsigneeVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commercialInvoiceConsigneeVatNumber)), __LINE__);
        }
        $this->commercialInvoiceConsigneeVatNumber = $commercialInvoiceConsigneeVatNumber;
        return $this;
    }
    /**
     * Get commercialInvoiceConsignee value
     * @return \cycro\StructType\Address|null
     */
    public function getCommercialInvoiceConsignee()
    {
        return $this->commercialInvoiceConsignee;
    }
    /**
     * Set commercialInvoiceConsignee value
     * @param \cycro\StructType\Address $commercialInvoiceConsignee
     * @return \cycro\StructType\International
     */
    public function setCommercialInvoiceConsignee(\cycro\StructType\Address $commercialInvoiceConsignee = null)
    {
        $this->commercialInvoiceConsignee = $commercialInvoiceConsignee;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\International
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
