<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hazardous StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles hazardous materials data.
 * @subpackage Structs
 */
class Hazardous extends AbstractStructBase
{
    /**
     * The identificationUnNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Defines UN number of hazardous substance. UN numbers range between 0004 and 9004.
     * - length: 4
     * @var string
     */
    public $identificationUnNo;
    /**
     * The identificationClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Defines class of hazardous substance. Possible values range from 1 to 9. Subclasses are specified as position after decimal point(e.g. class 1 is "explosives", class 1.6 is "extremely insensitive explosives").
     * - maxLength: 6
     * @var string
     */
    public $identificationClass;
    /**
     * The packingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $packingCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Description of hazardous substance (redundant).
     * - maxLength: 160
     * @var string
     */
    public $description;
    /**
     * The hazardousWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Weight of hazardous substance with 4 places before decimal point and 2 decimal places (with separator).
     * - fractionDigits: 2
     * - totalDigits: 6
     * @var float
     */
    public $hazardousWeight;
    /**
     * The factor
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Factor of hazardous substance (redundant ). 999 means unlimited.
     * - maxInclusive: 999
     * @var int
     */
    public $factor;
    /**
     * The classificationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines classification code of hazardous substance.
     * - maxLength: 5
     * @var string
     */
    public $classificationCode;
    /**
     * The packingGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines packing group of hazardous substance. Common values are "I", "II" or "III".
     * - maxLength: 5
     * @var string
     */
    public $packingGroup;
    /**
     * The subsidiaryRisk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Subsidiary risk of hazardous substance (redundant).
     * - maxLength: 10
     * @var string
     */
    public $subsidiaryRisk;
    /**
     * The tunnelRestrictionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tunnelRestrictionCode;
    /**
     * The netWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Net weight of hazardous substance with 4 places before decimal point and 2 decimal places (with separator).
     * - fractionDigits: 2
     * - totalDigits: 6
     * @var float
     */
    public $netWeight;
    /**
     * The notOtherwiseSpecified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A not otherwise specified text which is mandatory for some substances.
     * - maxLength: 150
     * @var string
     */
    public $notOtherwiseSpecified;
    /**
     * Constructor method for hazardous
     * @uses Hazardous::setIdentificationUnNo()
     * @uses Hazardous::setIdentificationClass()
     * @uses Hazardous::setPackingCode()
     * @uses Hazardous::setDescription()
     * @uses Hazardous::setHazardousWeight()
     * @uses Hazardous::setFactor()
     * @uses Hazardous::setClassificationCode()
     * @uses Hazardous::setPackingGroup()
     * @uses Hazardous::setSubsidiaryRisk()
     * @uses Hazardous::setTunnelRestrictionCode()
     * @uses Hazardous::setNetWeight()
     * @uses Hazardous::setNotOtherwiseSpecified()
     * @param string $identificationUnNo
     * @param string $identificationClass
     * @param string $packingCode
     * @param string $description
     * @param float $hazardousWeight
     * @param int $factor
     * @param string $classificationCode
     * @param string $packingGroup
     * @param string $subsidiaryRisk
     * @param string $tunnelRestrictionCode
     * @param float $netWeight
     * @param string $notOtherwiseSpecified
     */
    public function __construct($identificationUnNo = null, $identificationClass = null, $packingCode = null, $description = null, $hazardousWeight = null, $factor = null, $classificationCode = null, $packingGroup = null, $subsidiaryRisk = null, $tunnelRestrictionCode = null, $netWeight = null, $notOtherwiseSpecified = null)
    {
        $this
            ->setIdentificationUnNo($identificationUnNo)
            ->setIdentificationClass($identificationClass)
            ->setPackingCode($packingCode)
            ->setDescription($description)
            ->setHazardousWeight($hazardousWeight)
            ->setFactor($factor)
            ->setClassificationCode($classificationCode)
            ->setPackingGroup($packingGroup)
            ->setSubsidiaryRisk($subsidiaryRisk)
            ->setTunnelRestrictionCode($tunnelRestrictionCode)
            ->setNetWeight($netWeight)
            ->setNotOtherwiseSpecified($notOtherwiseSpecified);
    }
    /**
     * Get identificationUnNo value
     * @return string
     */
    public function getIdentificationUnNo()
    {
        return $this->identificationUnNo;
    }
    /**
     * Set identificationUnNo value
     * @param string $identificationUnNo
     * @return \cycro\StructType\Hazardous
     */
    public function setIdentificationUnNo($identificationUnNo = null)
    {
        // validation for constraint: length
        if ((is_scalar($identificationUnNo) && strlen($identificationUnNo) !== 4) || (is_array($identificationUnNo) && count($identificationUnNo) !== 4)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificationUnNo) && !is_string($identificationUnNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificationUnNo)), __LINE__);
        }
        $this->identificationUnNo = $identificationUnNo;
        return $this;
    }
    /**
     * Get identificationClass value
     * @return string
     */
    public function getIdentificationClass()
    {
        return $this->identificationClass;
    }
    /**
     * Set identificationClass value
     * @param string $identificationClass
     * @return \cycro\StructType\Hazardous
     */
    public function setIdentificationClass($identificationClass = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificationClass) && strlen($identificationClass) > 6) || (is_array($identificationClass) && count($identificationClass) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($identificationClass) ? strlen($identificationClass) : count($identificationClass)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificationClass) && !is_string($identificationClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificationClass)), __LINE__);
        }
        $this->identificationClass = $identificationClass;
        return $this;
    }
    /**
     * Get packingCode value
     * @return string
     */
    public function getPackingCode()
    {
        return $this->packingCode;
    }
    /**
     * Set packingCode value
     * @uses \cycro\EnumType\PackingCode::valueIsValid()
     * @uses \cycro\EnumType\PackingCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packingCode
     * @return \cycro\StructType\Hazardous
     */
    public function setPackingCode($packingCode = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\PackingCode::valueIsValid($packingCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packingCode, implode(', ', \cycro\EnumType\PackingCode::getValidValues())), __LINE__);
        }
        $this->packingCode = $packingCode;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \cycro\StructType\Hazardous
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 160) || (is_array($description) && count($description) > 160)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 160 element(s) or a scalar of 160 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get hazardousWeight value
     * @return float
     */
    public function getHazardousWeight()
    {
        return $this->hazardousWeight;
    }
    /**
     * Set hazardousWeight value
     * @param float $hazardousWeight
     * @return \cycro\StructType\Hazardous
     */
    public function setHazardousWeight($hazardousWeight = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($hazardousWeight) && strlen(substr($hazardousWeight, strpos($hazardousWeight, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($hazardousWeight, strpos($hazardousWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($hazardousWeight) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $hazardousWeight)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 digits, "%d" given', strlen(substr($hazardousWeight, strpos($hazardousWeight, '.')))), __LINE__);
        }
        $this->hazardousWeight = $hazardousWeight;
        return $this;
    }
    /**
     * Get factor value
     * @return int
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param int $factor
     * @return \cycro\StructType\Hazardous
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: maxInclusive
        if ($factor > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999, "%s" given', $factor), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($factor) && !is_numeric($factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($factor)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
    /**
     * Get classificationCode value
     * @return string|null
     */
    public function getClassificationCode()
    {
        return $this->classificationCode;
    }
    /**
     * Set classificationCode value
     * @param string $classificationCode
     * @return \cycro\StructType\Hazardous
     */
    public function setClassificationCode($classificationCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($classificationCode) && strlen($classificationCode) > 5) || (is_array($classificationCode) && count($classificationCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($classificationCode) ? strlen($classificationCode) : count($classificationCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($classificationCode) && !is_string($classificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classificationCode)), __LINE__);
        }
        $this->classificationCode = $classificationCode;
        return $this;
    }
    /**
     * Get packingGroup value
     * @return string|null
     */
    public function getPackingGroup()
    {
        return $this->packingGroup;
    }
    /**
     * Set packingGroup value
     * @param string $packingGroup
     * @return \cycro\StructType\Hazardous
     */
    public function setPackingGroup($packingGroup = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($packingGroup) && strlen($packingGroup) > 5) || (is_array($packingGroup) && count($packingGroup) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($packingGroup) ? strlen($packingGroup) : count($packingGroup)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($packingGroup) && !is_string($packingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packingGroup)), __LINE__);
        }
        $this->packingGroup = $packingGroup;
        return $this;
    }
    /**
     * Get subsidiaryRisk value
     * @return string|null
     */
    public function getSubsidiaryRisk()
    {
        return $this->subsidiaryRisk;
    }
    /**
     * Set subsidiaryRisk value
     * @param string $subsidiaryRisk
     * @return \cycro\StructType\Hazardous
     */
    public function setSubsidiaryRisk($subsidiaryRisk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subsidiaryRisk) && strlen($subsidiaryRisk) > 10) || (is_array($subsidiaryRisk) && count($subsidiaryRisk) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($subsidiaryRisk) ? strlen($subsidiaryRisk) : count($subsidiaryRisk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subsidiaryRisk) && !is_string($subsidiaryRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subsidiaryRisk)), __LINE__);
        }
        $this->subsidiaryRisk = $subsidiaryRisk;
        return $this;
    }
    /**
     * Get tunnelRestrictionCode value
     * @return string|null
     */
    public function getTunnelRestrictionCode()
    {
        return $this->tunnelRestrictionCode;
    }
    /**
     * Set tunnelRestrictionCode value
     * @uses \cycro\EnumType\TunnelRestrictionCode::valueIsValid()
     * @uses \cycro\EnumType\TunnelRestrictionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunnelRestrictionCode
     * @return \cycro\StructType\Hazardous
     */
    public function setTunnelRestrictionCode($tunnelRestrictionCode = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\TunnelRestrictionCode::valueIsValid($tunnelRestrictionCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tunnelRestrictionCode, implode(', ', \cycro\EnumType\TunnelRestrictionCode::getValidValues())), __LINE__);
        }
        $this->tunnelRestrictionCode = $tunnelRestrictionCode;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \cycro\StructType\Hazardous
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($netWeight) && strlen(substr($netWeight, strpos($netWeight, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($netWeight, strpos($netWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($netWeight) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $netWeight)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 digits, "%d" given', strlen(substr($netWeight, strpos($netWeight, '.')))), __LINE__);
        }
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get notOtherwiseSpecified value
     * @return string|null
     */
    public function getNotOtherwiseSpecified()
    {
        return $this->notOtherwiseSpecified;
    }
    /**
     * Set notOtherwiseSpecified value
     * @param string $notOtherwiseSpecified
     * @return \cycro\StructType\Hazardous
     */
    public function setNotOtherwiseSpecified($notOtherwiseSpecified = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($notOtherwiseSpecified) && strlen($notOtherwiseSpecified) > 150) || (is_array($notOtherwiseSpecified) && count($notOtherwiseSpecified) > 150)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 150 element(s) or a scalar of 150 character(s) at most, "%d" length given', is_scalar($notOtherwiseSpecified) ? strlen($notOtherwiseSpecified) : count($notOtherwiseSpecified)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($notOtherwiseSpecified) && !is_string($notOtherwiseSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notOtherwiseSpecified)), __LINE__);
        }
        $this->notOtherwiseSpecified = $notOtherwiseSpecified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Hazardous
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
