<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faultCodeType StructType
 * @subpackage Structs
 */
class FaultCodeType extends AbstractStructBase
{
    /**
     * The faultCode
     * Meta informations extracted from the WSDL
     * - documentation: Possible error codes are:SHIPPING_1 - pickup address is unknown for customerSHIPPING_2 - parcel label print failsCOMMON_1 - unexpected runtime errorCOMMON_2 - mandatory input field is emptyCOMMON_3 - length of data for field does not
     * fitCOMMON_4 - input data contains invalid special characterCOMMON_5 - a swap parcel is ordered, but there is more than one parcelCOMMON_6 - some input data field values result in an invalid combinationCOMMON_7 - input data contains invalid
     * valueCOMMON_8 - a field is to be stored in database, but there is not database field mapped for itDATABASE_6 - transfer state of order is to be changed but order is already committedDATABASE_7 - update fails on database level during order
     * storingDATABASE_8 - delete fails on database level during rollback after some other errorDATABASE_21 - order is to be inserted in databse, but has already a database idDATABASE_22 - order is to be committed after inserting, but there is no database
     * id for update givenDATABASE_24 - deletion is necessary because of some other error, but no database id for record is givenMPSEXP_1 - parcel label number is already in useROUTING_1 - no route could be found for depot and featureROUTING_2 - invalid
     * input dataROUTING_3 - the connection to the database failedROUTING_4 - an internal failure occursROUTING_5 - no depot could be foundROUTING_6 - no pickup date was givenROUTING_7 - internal extension rule errorROUTING_8 - malformed zip codeROUTING_9 -
     * missing country codeROUTING_10 - missing routing placeROUTING_11 - missing service codeROUTING_12 - routing place errorROUTING_13 - sending date errorROUTING_14 - service code errorROUTING_15 - invalid relation of service codesROUTING_16 - unknown
     * country codeROUTING_17 - unknown destination depotROUTING_18 - unknown zip codeROUTING_19 - unknown routing placeROUTING_20 - unknown service codeROUTING_21 - invalid service codeROUTING_21 - parcel is labelled as return parcel but returns is not
     * possibleROUTING_22 - missing allowROUTING_23 - missing routing place or destination depot
     * @var string
     */
    public $faultCode;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - documentation: Message with detailed information for the fault (e.g. incorrect field).
     * @var string
     */
    public $message;
    /**
     * Constructor method for faultCodeType
     * @uses FaultCodeType::setFaultCode()
     * @uses FaultCodeType::setMessage()
     * @param string $faultCode
     * @param string $message
     */
    public function __construct($faultCode = null, $message = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setMessage($message);
    }
    /**
     * Get faultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->faultCode;
    }
    /**
     * Set faultCode value
     * @param string $faultCode
     * @return \cycro\StructType\FaultCodeType
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultCode)), __LINE__);
        }
        $this->faultCode = $faultCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \cycro\StructType\FaultCodeType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\FaultCodeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
