<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for delivery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles delivery data.
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The day
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Allowed delivery days in the week (0 = Sunday, 1 = Monday etc.).Comma separated list of possible delivery days (e.g. "2,3,4,5"). | Pickup day of week for consignments and pickup information. Allowed values are 0..6 (0=Sunday,
     * 1=Monday, etc.). Mandatory for consignment.
     * - maxInclusive: 6
     * - maxLength: 20
     * @var int
     */
    public $day;
    /**
     * The dateFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Fixed delivery from date - format YYYYMMDD, e.g. 20080213.
     * - maxInclusive: 99999999
     * @var int
     */
    public $dateFrom;
    /**
     * The dateTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Fixed delivery to date - format YYYYMMDD, e.g. 20080213.
     * - maxInclusive: 99999999
     * @var int
     */
    public $dateTo;
    /**
     * The timeFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Time from which the consignee is available - format hhmm (local time receipient country), e.g. 1400 or 0830.
     * - maxInclusive: 2400
     * @var int
     */
    public $timeFrom;
    /**
     * The timeTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Time until the consignee is available - format hhmm (local time receipient country), e.g. 1600 or 0930.
     * - maxInclusive: 2400
     * @var int
     */
    public $timeTo;
    /**
     * Constructor method for delivery
     * @uses Delivery::setDay()
     * @uses Delivery::setDateFrom()
     * @uses Delivery::setDateTo()
     * @uses Delivery::setTimeFrom()
     * @uses Delivery::setTimeTo()
     * @param int $day
     * @param int $dateFrom
     * @param int $dateTo
     * @param int $timeFrom
     * @param int $timeTo
     */
    public function __construct($day = null, $dateFrom = null, $dateTo = null, $timeFrom = null, $timeTo = null)
    {
        $this
            ->setDay($day)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setTimeFrom($timeFrom)
            ->setTimeTo($timeTo);
    }
    /**
     * Get day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \cycro\StructType\Delivery
     */
    public function setDay($day = null)
    {
        // validation for constraint: maxInclusive
        if ($day > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 6, "%s" given', $day), __LINE__);
        }
        // validation for constraint: maxLength
        if ((is_scalar($day) && strlen($day) > 20) || (is_array($day) && count($day) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($day) ? strlen($day) : count($day)), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($day) && !is_numeric($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get dateFrom value
     * @return int|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param int $dateFrom
     * @return \cycro\StructType\Delivery
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: maxInclusive
        if ($dateFrom > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999, "%s" given', $dateFrom), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($dateFrom) && !is_numeric($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dateFrom)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return int|null
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param int $dateTo
     * @return \cycro\StructType\Delivery
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: maxInclusive
        if ($dateTo > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999, "%s" given', $dateTo), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($dateTo) && !is_numeric($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dateTo)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
    /**
     * Get timeFrom value
     * @return int|null
     */
    public function getTimeFrom()
    {
        return $this->timeFrom;
    }
    /**
     * Set timeFrom value
     * @param int $timeFrom
     * @return \cycro\StructType\Delivery
     */
    public function setTimeFrom($timeFrom = null)
    {
        // validation for constraint: maxInclusive
        if ($timeFrom > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2400, "%s" given', $timeFrom), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($timeFrom) && !is_numeric($timeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeFrom)), __LINE__);
        }
        $this->timeFrom = $timeFrom;
        return $this;
    }
    /**
     * Get timeTo value
     * @return int|null
     */
    public function getTimeTo()
    {
        return $this->timeTo;
    }
    /**
     * Set timeTo value
     * @param int $timeTo
     * @return \cycro\StructType\Delivery
     */
    public function setTimeTo($timeTo = null)
    {
        // validation for constraint: maxInclusive
        if ($timeTo > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2400, "%s" given', $timeTo), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($timeTo) && !is_numeric($timeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeTo)), __LINE__);
        }
        $this->timeTo = $timeTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
