<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cod StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles cash on delivery data.
 * @subpackage Structs
 */
class Cod extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: COD amount in the currency of the destination country. The amount is specified as integer value e.g. 300.00 becomes 30000.Please note the national ceilings for cod in the corresponding relations. | Increased insurance value with 2
     * decimal point positions without separators.
     * - maxInclusive: 9999999999
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: ISO 4217 alpha-3 currency code (destination country). | Currency code for increased insurance in format ISO 4217 alpha 3.
     * - length: 3
     * @var string
     */
    public $currency;
    /**
     * The inkasso
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $inkasso;
    /**
     * The purpose
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Purpose of use.
     * - maxLength: 14
     * @var string
     */
    public $purpose;
    /**
     * The bankCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Bank code.If this value is filled, parameters for bankName, bankAccountNumber and bankAccountHolder must also be filled.
     * - maxLength: 25
     * @var string
     */
    public $bankCode;
    /**
     * The bankName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Bank name.If this value is filled, parameters for bankCode, bankAccountNumber and bankAccountHolder must also be filled.
     * - maxLength: 27
     * @var string
     */
    public $bankName;
    /**
     * The bankAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Bank account number.If this value is filled, parameters for bankCode, bankName and bankAccountHolder must also be filled.
     * - maxLength: 25
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The bankAccountHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Account holder.If this value is filled, parameters for bankCode, bankName and bankAccountNumber must also be filled.
     * - maxLength: 30
     * @var string
     */
    public $bankAccountHolder;
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: International bank account number .If this value is filled, parameters for bankCode, bankName, bankAccountNumber and bankAccountHolder must also be filled.
     * - maxLength: 50
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Bank identifier code.If this value is filled, parameters for bankCode, bankName, bankAccountNumber and bankAccountHolder must also be filled.
     * - maxLength: 50
     * @var string
     */
    public $bic;
    /**
     * Constructor method for cod
     * @uses Cod::setAmount()
     * @uses Cod::setCurrency()
     * @uses Cod::setInkasso()
     * @uses Cod::setPurpose()
     * @uses Cod::setBankCode()
     * @uses Cod::setBankName()
     * @uses Cod::setBankAccountNumber()
     * @uses Cod::setBankAccountHolder()
     * @uses Cod::setIban()
     * @uses Cod::setBic()
     * @param int $amount
     * @param string $currency
     * @param string $inkasso
     * @param string $purpose
     * @param string $bankCode
     * @param string $bankName
     * @param string $bankAccountNumber
     * @param string $bankAccountHolder
     * @param string $iban
     * @param string $bic
     */
    public function __construct($amount = null, $currency = null, $inkasso = null, $purpose = null, $bankCode = null, $bankName = null, $bankAccountNumber = null, $bankAccountHolder = null, $iban = null, $bic = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setInkasso($inkasso)
            ->setPurpose($purpose)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBankAccountNumber($bankAccountNumber)
            ->setBankAccountHolder($bankAccountHolder)
            ->setIban($iban)
            ->setBic($bic);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \cycro\StructType\Cod
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: maxInclusive
        if ($amount > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $amount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \cycro\StructType\Cod
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: length
        if ((is_scalar($currency) && strlen($currency) !== 3) || (is_array($currency) && count($currency) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get inkasso value
     * @return string
     */
    public function getInkasso()
    {
        return $this->inkasso;
    }
    /**
     * Set inkasso value
     * @uses \cycro\EnumType\Inkasso::valueIsValid()
     * @uses \cycro\EnumType\Inkasso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inkasso
     * @return \cycro\StructType\Cod
     */
    public function setInkasso($inkasso = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\Inkasso::valueIsValid($inkasso)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inkasso, implode(', ', \cycro\EnumType\Inkasso::getValidValues())), __LINE__);
        }
        $this->inkasso = $inkasso;
        return $this;
    }
    /**
     * Get purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @param string $purpose
     * @return \cycro\StructType\Cod
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($purpose) && strlen($purpose) > 14) || (is_array($purpose) && count($purpose) > 14)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 14 element(s) or a scalar of 14 character(s) at most, "%d" length given', is_scalar($purpose) ? strlen($purpose) : count($purpose)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purpose)), __LINE__);
        }
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \cycro\StructType\Cod
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankCode) && strlen($bankCode) > 25) || (is_array($bankCode) && count($bankCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($bankCode) ? strlen($bankCode) : count($bankCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \cycro\StructType\Cod
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankName) && strlen($bankName) > 27) || (is_array($bankName) && count($bankName) > 27)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 27 element(s) or a scalar of 27 character(s) at most, "%d" length given', is_scalar($bankName) ? strlen($bankName) : count($bankName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \cycro\StructType\Cod
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankAccountNumber) && strlen($bankAccountNumber) > 25) || (is_array($bankAccountNumber) && count($bankAccountNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($bankAccountNumber) ? strlen($bankAccountNumber) : count($bankAccountNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get bankAccountHolder value
     * @return string|null
     */
    public function getBankAccountHolder()
    {
        return $this->bankAccountHolder;
    }
    /**
     * Set bankAccountHolder value
     * @param string $bankAccountHolder
     * @return \cycro\StructType\Cod
     */
    public function setBankAccountHolder($bankAccountHolder = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankAccountHolder) && strlen($bankAccountHolder) > 30) || (is_array($bankAccountHolder) && count($bankAccountHolder) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($bankAccountHolder) ? strlen($bankAccountHolder) : count($bankAccountHolder)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankAccountHolder) && !is_string($bankAccountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountHolder)), __LINE__);
        }
        $this->bankAccountHolder = $bankAccountHolder;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \cycro\StructType\Cod
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 50) || (is_array($iban) && count($iban) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \cycro\StructType\Cod
     */
    public function setBic($bic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bic) && strlen($bic) > 50) || (is_array($bic) && count($bic) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($bic) ? strlen($bic) : count($bic)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Cod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
