<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authenticationFault StructType
 * Meta informations extracted from the WSDL
 * - documentation: The data structure for authentication errors. | The data structure for authentication errors.
 * @subpackage Structs
 */
class AuthenticationFault extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: The error code. Valid codes: NoAccessAuthenticationFault=-1 NoRightsAuthenticationFault=-2
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: The error message text.
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for authenticationFault
     * @uses AuthenticationFault::setErrorCode()
     * @uses AuthenticationFault::setErrorMessage()
     * @param string $errorCode
     * @param string $errorMessage
     */
    public function __construct($errorCode = null, $errorMessage = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \cycro\StructType\AuthenticationFault
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \cycro\StructType\AuthenticationFault
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($errorMessage) && strlen($errorMessage) > 255) || (is_array($errorMessage) && count($errorMessage) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($errorMessage) ? strlen($errorMessage) : count($errorMessage)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($errorMessage) && strlen($errorMessage) < 1) || (is_array($errorMessage) && count($errorMessage) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\AuthenticationFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
